/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Attachment;
import com.nukateam.ntgl.common.data.config.AmmoConfig;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.attachment.Modifiers;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];
    public static final ProjectileConfig PROJECTILE = new ProjectileConfig();

    @Deprecated
    public static ProjectileConfig getCurrentAmmo(GunData data) {
        return GunStateHelper.getProjectileConfig(data);
    }

    public static boolean isAuto(GunData itemStack) {
        return GunStateHelper.getFireMode(itemStack) == FireMode.AUTO;
    }

    public static boolean isWeaponFull(GunData data) {
        CompoundTag tag = data.gun.m_41784_();
        Gun gun = ((WeaponItem)data.gun.m_41720_()).getModifiedGun(data.gun);
        return tag.m_128451_("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(data);
    }

    public static boolean canRenderInOffhand(LivingEntity player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        return GunStateHelper.isOneHanded(new GunData(mainHandItem, player)) && GunStateHelper.isOneHanded(new GunData(offhandItem, player));
    }

    public static boolean isGun(ItemStack data) {
        Item gunItem = data.m_41720_();
        return gunItem instanceof WeaponItem;
    }

    public static Gun getGun(ItemStack stack) {
        WeaponItem gunItem = (WeaponItem)stack.m_41720_();
        return gunItem.getModifiedGun(stack);
    }

    public static General getGeneral(Gun gun) {
        return gun.getGeneral();
    }

    public static Set<AttachmentType> getAttachmentTypes(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        return gun.getModules().getAttachments().keySet();
    }

    public static boolean isAlwaysSpread(GunData data) {
        AtomicBoolean isAlwaysSpread = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isAlwaysSpread());
        return isAlwaysSpread.get();
    }

    public static int getMaxAmmo(GunData data) {
        AtomicInteger finalMaxAmmo = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getMaxAmmo());
        ProjectileConfig config = GunStateHelper.getProjectileConfig(data);
        if (data != null && config != null && data.gun.m_41720_() instanceof WeaponItem && GunStateHelper.getProjectileConfig(data).isMagazineMode()) {
            AmmoHolder id = GunStateHelper.getCurrentAmmo(data);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id.getId());
            finalMaxAmmo.set(item.getMaxDamage(new ItemStack((ItemLike)item)));
        }
        GunModifierHelper.forEachAttachment(data, modifier -> finalMaxAmmo.set(modifier.modifyMaxAmmo(finalMaxAmmo.get(), data)));
        return finalMaxAmmo.get();
    }

    public static boolean isAutoReloading(GunData data) {
        AtomicBoolean autoReloading = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isAutoReloading());
        GunModifierHelper.forEachAttachment(data, modifier -> autoReloading.set(modifier.modifyAutoReloading(autoReloading.get(), data)));
        return autoReloading.get();
    }

    public static ResourceLocation getFireSound(GunData data) {
        AtomicReference<ResourceLocation> fireSound = new AtomicReference<ResourceLocation>(GunModifierHelper.getGun(data.gun).getSounds().getFire());
        GunModifierHelper.forEachAttachment(data, modifier -> fireSound.set(modifier.modifyFireSound((ResourceLocation)fireSound.get(), data)));
        return fireSound.get();
    }

    public static boolean shouldRenderHud(GunData data) {
        AtomicBoolean renderHud = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).shouldRenderHud());
        GunModifierHelper.forEachAttachment(data, modifier -> renderHud.set(modifier.modifyShouldRenderHud(renderHud.get(), data)));
        return renderHud.get();
    }

    public static LoadingType getLoadingType(GunData data) {
        AtomicReference<LoadingType> loadingType = new AtomicReference<LoadingType>(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getLoadingType());
        GunModifierHelper.forEachAttachment(data, modifier -> loadingType.set(modifier.modifyLoadingType((LoadingType)loadingType.get(), data)));
        return loadingType.get();
    }

    public static WeaponMode getWeaponMode(GunData data) {
        AtomicReference<WeaponMode> loadingType = new AtomicReference<WeaponMode>(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getWeaponMode());
        GunModifierHelper.forEachAttachment(data, modifier -> loadingType.set(modifier.modifyWeaponMode((WeaponMode)loadingType.get(), data)));
        return loadingType.get();
    }

    public static int getProjectileAmount(GunData data) {
        int gunProjectileAmount = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getProjectileAmount();
        int ammoProjectileAmount = GunStateHelper.getProjectileConfig(data).getProjectileAmount();
        AtomicInteger finalProjectileAmount = new AtomicInteger(gunProjectileAmount * ammoProjectileAmount);
        GunModifierHelper.forEachAttachment(data, modifier -> finalProjectileAmount.set(modifier.modifyProjectileAmount(finalProjectileAmount.get(), data)));
        return finalProjectileAmount.get();
    }

    public static int getReloadAmount(GunData data) {
        AtomicInteger value = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadAmount());
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyReloadAmount(value.get(), data)));
        return value.get();
    }

    public static int getMultishotAmount(GunData data) {
        AtomicInteger value = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getMultishotAmount());
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyMultishotAmount(value.get(), data)));
        return value.get();
    }

    public static Set<FireMode> getFireModes(GunData data) {
        Set<FireMode> fireMode = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getFireModes();
        AtomicReference<Set<FireMode>> finalFireMode = new AtomicReference<Set<FireMode>>(fireMode);
        GunModifierHelper.forEachAttachment(data, modifier -> finalFireMode.set(modifier.modifyFireModes((Set)finalFireMode.get(), data)));
        return finalFireMode.get();
    }

    public static GripType getGripType(GunData data) {
        if (data.gun == null) {
            return GripType.ONE_HANDED;
        }
        GripType gripType = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getGripType();
        AtomicReference<GripType> finalGripType = new AtomicReference<GripType>(gripType);
        GunModifierHelper.forEachAttachment(data, modifier -> finalGripType.set(modifier.modifyGripType((GripType)finalGripType.get(), data)));
        return finalGripType.get();
    }

    public static int getFireDelay(GunData data) {
        AtomicInteger chargeTime = new AtomicInteger(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getFireDelay());
        GunModifierHelper.forEachAttachment(data, modifier -> chargeTime.set(modifier.modifyFireDelay(chargeTime.get(), data)));
        return chargeTime.get();
    }

    public static Fuel getFuel(ResourceLocation type, GunData data) {
        AtomicReference<Fuel> value = new AtomicReference<Fuel>(GunModifierHelper.getGun(data.gun).getFuelConfig(type));
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyFuel((Fuel)value.get(), data)));
        return value.get();
    }

    public static ResourceLocation getAnimation(AnimationType type, GunData data) {
        AtomicReference<ResourceLocation> value = new AtomicReference<ResourceLocation>(GunModifierHelper.getGun(data.gun).getAnimation(type));
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyAnimation(type, (ResourceLocation)value.get(), data)));
        return value.get();
    }

    public static boolean needsFullCharge(GunData data) {
        AtomicBoolean needsFullCharge = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isFullCharge());
        GunModifierHelper.forEachAttachment(data, modifier -> needsFullCharge.set(modifier.modifyNeedsFullCharge(needsFullCharge.get(), data)));
        return needsFullCharge.get();
    }

    public static boolean isOneTimeCharge(GunData data) {
        AtomicBoolean oneTimeCharge = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isOneTimeCharge());
        GunModifierHelper.forEachAttachment(data, modifier -> oneTimeCharge.set(modifier.modifyIsOneTimeCharge(oneTimeCharge.get(), data)));
        return oneTimeCharge.get();
    }

    public static boolean canMelee(GunData data) {
        AtomicBoolean value = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).canMelee());
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyCanMelee(value.get(), data)));
        return value.get();
    }

    public static Set<AmmoHolder> getAmmoItems(GunData data) {
        Set<AmmoHolder> items = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getAmmo();
        AtomicReference<Set<AmmoHolder>> ammoItem = new AtomicReference<Set<AmmoHolder>>(items);
        GunModifierHelper.forEachAttachment(data, modifier -> ammoItem.set(modifier.modifyAmmoItems((Set)ammoItem.get(), data)));
        return ammoItem.get();
    }

    public static Set<AmmoHolder> getAllFuel(GunData data) {
        Set<AmmoHolder> items = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getFuel();
        AtomicReference<Set<AmmoHolder>> ammoItem = new AtomicReference<Set<AmmoHolder>>(items);
        GunModifierHelper.forEachAttachment(data, modifier -> ammoItem.set(modifier.modifyFuelItems((Set)ammoItem.get(), data)));
        return ammoItem.get();
    }

    public static AmmoHolder getFirstAmmoItem(GunData data) {
        Set<AmmoHolder> items = GunModifierHelper.getAmmoItems(data);
        return items.iterator().next();
    }

    public static int getReloadStart(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadStart();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadStart(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadTime(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadTime();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadTime(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadEnd(GunData data) {
        int reloadTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getReloadEnd();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadEnd(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getEquipTime(GunData data) {
        int equipTime = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getEquipTime();
        AtomicInteger finalEquipTime = new AtomicInteger(equipTime);
        GunModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyEquipTime(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getAmmoPerShot(GunData data) {
        int value = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getAmmoPerShot();
        AtomicInteger finalEquipTime = new AtomicInteger(value);
        GunModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyAmmoPerShot(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getModifiedProjectileLife(GunData data, int life) {
        AtomicInteger finalLife = new AtomicInteger(life);
        GunModifierHelper.forEachAttachment(data, modifier -> finalLife.set(modifier.modifyProjectileLife(finalLife.get(), data)));
        return finalLife.get();
    }

    public static double getModifiedProjectileGravity(GunData data, double gravity) {
        AtomicReference<Double> finalGravity = new AtomicReference<Double>(gravity);
        GunModifierHelper.forEachAttachment(data, modifier -> finalGravity.set(modifier.modifyProjectileGravity((Double)finalGravity.get(), data)));
        GunModifierHelper.forEachAttachment(data, modifier -> finalGravity.updateAndGet(v -> v + modifier.additionalProjectileGravity(data)));
        return finalGravity.get();
    }

    public static float getModifiedSpread(GunData data) {
        float gunSpread = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getSpread();
        float ammoSpread = GunStateHelper.getProjectileConfig(data).getSpread();
        float spread = Math.max(gunSpread + ammoSpread, 0.0f);
        AtomicReference<Float> finalSpread = new AtomicReference<Float>(Float.valueOf(spread));
        GunModifierHelper.forEachAttachment(data, modifier -> finalSpread.set(Float.valueOf(modifier.modifyProjectileSpread(((Float)finalSpread.get()).floatValue(), data))));
        return finalSpread.get().floatValue();
    }

    public static float getModifiedMovementSpeed(GunData data) {
        float gunSpread = GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).getMovementSpeed();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(gunSpread));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMovementSpeed(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static double getModifiedProjectileSpeed(GunData data, double speed) {
        AtomicReference<Double> finalSpeed = new AtomicReference<Double>(speed);
        GunModifierHelper.forEachAttachment(data, modifier -> finalSpeed.set(modifier.modifyProjectileSpeed((Double)finalSpeed.get(), data)));
        return finalSpeed.get();
    }

    public static float getFireSoundVolume(GunData data) {
        AtomicReference<Float> volume = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> volume.set(Float.valueOf(modifier.modifyFireSoundVolume(((Float)volume.get()).floatValue(), data))));
        return Mth.m_14036_((float)volume.get().floatValue(), (float)0.0f, (float)16.0f);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static double getMuzzleFlashSize(GunData data, double size) {
        AtomicReference<Double> finalSize = new AtomicReference<Double>(size);
        GunModifierHelper.forEachAttachment(data, modifier -> finalSize.set(modifier.modifyMuzzleFlashSize((Double)finalSize.get(), data)));
        return finalSize.get();
    }

    public static double getMuzzleFlashScale(GunData data, double scale) {
        AtomicReference<Double> finalScale = new AtomicReference<Double>(scale);
        GunModifierHelper.forEachAttachment(data, modifier -> finalScale.set(modifier.modifyMuzzleFlashScale(scale, data)));
        return finalScale.get();
    }

    public static float getKickReduction(GunData data) {
        AtomicReference<Float> kickReduction = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> kickReduction.updateAndGet(v -> Float.valueOf(v.floatValue() * Mth.m_14036_((float)modifier.kickModifier(data), (float)0.0f, (float)1.0f))));
        return 1.0f - kickReduction.get().floatValue();
    }

    public static float getRecoilModifier(GunData data) {
        AtomicReference<Float> recoilReduction = new AtomicReference<Float>(Float.valueOf(1.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> recoilReduction.updateAndGet(v -> Float.valueOf(v.floatValue() * Mth.m_14036_((float)modifier.recoilModifier(data), (float)0.0f, (float)1.0f))));
        return 1.0f - recoilReduction.get().floatValue();
    }

    public static boolean isSilencedFire(GunData data) {
        AtomicBoolean value = new AtomicBoolean(GunModifierHelper.getGeneral(GunModifierHelper.getGun(data.gun)).isSilenced());
        GunModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.silencedFire(value.get(), data)));
        return value.get();
    }

    public static double getModifiedFireSoundRadius(GunData data, double radius) {
        AtomicReference<Double> minRadius = new AtomicReference<Double>(radius);
        GunModifierHelper.forEachAttachment(data, modifier -> {
            double newRadius = modifier.modifyFireSoundRadius(radius, data);
            if (newRadius < (Double)minRadius.get()) {
                minRadius.set(newRadius);
            }
        });
        return Mth.m_14008_((double)minRadius.get(), (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(GunData data) {
        AtomicReference<Float> additionalDamage = new AtomicReference<Float>(Float.valueOf(0.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> additionalDamage.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.additionalDamage(data))));
        return additionalDamage.get().floatValue();
    }

    public static float getModifiedDamage(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        float damage = GunModifierHelper.getGeneral(gun).getDamage();
        AtomicReference<Float> finalDamage = new AtomicReference<Float>(Float.valueOf(damage *= GunModifierHelper.getAmmoDamageMultiplier(data)));
        GunModifierHelper.forEachAttachment(data, modifier -> finalDamage.set(Float.valueOf(modifier.modifyDamage(((Float)finalDamage.get()).floatValue(), data))));
        GunModifierHelper.forEachAttachment(data, modifier -> finalDamage.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.additionalDamage(data))));
        return finalDamage.get().floatValue();
    }

    public static float getAmmoDamageMultiplier(GunData data) {
        return GunStateHelper.getProjectileConfig(data).getDamage();
    }

    public static double getModifiedAimDownSightSpeed(GunData data) {
        double speed = GunEnchantmentHelper.getAimDownSightSpeed(data.gun);
        AtomicReference<Double> buffSpeed = new AtomicReference<Double>(speed);
        GunModifierHelper.forEachAttachment(data, modifier -> buffSpeed.set(modifier.modifyAimDownSightSpeed((Double)buffSpeed.get(), data)));
        return Mth.m_14008_((double)buffSpeed.get(), (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getRate(GunData data) {
        Gun gun = GunModifierHelper.getGun(data.gun);
        int rate = GunEnchantmentHelper.getRate(data.gun, gun);
        AtomicInteger buffRate = new AtomicInteger(rate);
        GunModifierHelper.forEachAttachment(data, modifier -> buffRate.set(modifier.modifyFireRate(buffRate.get(), data)));
        return Mth.m_14045_((int)buffRate.get(), (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(GunData data) {
        AtomicReference<Float> chance = new AtomicReference<Float>(Float.valueOf(0.0f));
        GunModifierHelper.forEachAttachment(data, modifier -> chance.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.criticalChance(data))));
        chance.updateAndGet(v -> Float.valueOf(v.floatValue() + GunEnchantmentHelper.getPuncturingChance(data.gun)));
        return Mth.m_14036_((float)chance.get().floatValue(), (float)0.0f, (float)1.0f);
    }

    public static int getMeleeCooldown(GunData data) {
        int time = GunModifierHelper.getGun(data.gun).getMelee().getCooldown();
        AtomicInteger finalTime = new AtomicInteger(time);
        GunModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeCooldown(finalTime.get(), data)));
        return finalTime.get();
    }

    public static int getMeleeDelay(GunData data) {
        int time = GunModifierHelper.getGun(data.gun).getMelee().getDelay();
        AtomicInteger finalTime = new AtomicInteger(time);
        GunModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeDelay(finalTime.get(), data)));
        return finalTime.get();
    }

    public static int getMeleeMaxTargets(GunData data) {
        int time = GunModifierHelper.getGun(data.gun).getMelee().getMaxTargets();
        AtomicInteger finalTime = new AtomicInteger(time);
        GunModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeMaxTargets(finalTime.get(), data)));
        return finalTime.get();
    }

    public static float getMeleeDamage(GunData data) {
        float value = GunModifierHelper.getGun(data.gun).getMelee().getDamage();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeDamage(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeDistance(GunData data) {
        float value = GunModifierHelper.getGun(data.gun).getMelee().getDistance();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeDistance(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeAngle(GunData data) {
        float value = GunModifierHelper.getGun(data.gun).getMelee().getAngle();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeAngle(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeKnockback(GunData data) {
        float value = GunModifierHelper.getGun(data.gun).getMelee().getKnockback();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeKnockback(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static ProjectileConfig getProjectileConfig(ResourceLocation ammoId, GunData data) {
        Object object;
        Gun gun = GunModifierHelper.getGun(data.gun);
        ProjectileConfig config = null;
        AmmoHolder item = GunStateHelper.getCurrentAmmoWithoutCheck(data);
        if (gun.hasAmmo(ammoId)) {
            config = gun.getProjectileConfig(ammoId);
        } else if (item.canReturnAmmo() && (object = ForgeRegistries.ITEMS.getValue(item.getId())) instanceof IAmmo) {
            IAmmo ammoItem = (IAmmo)object;
            config = ammoItem.getAmmo();
        }
        if (config == null) {
            config = new ProjectileConfig();
        }
        AtomicReference<ProjectileConfig> finalValue = new AtomicReference<ProjectileConfig>(config);
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyProjectile((ProjectileConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static AmmoConfig getAmmoConfig(ResourceLocation ammoId, GunData data) {
        AtomicReference<AmmoConfig> finalValue = new AtomicReference<AmmoConfig>(GunModifierHelper.getGun(data.gun).getAmmoConfig(ammoId));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyAmmo((AmmoConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static AmmoConfig getFuelAmmoConfig(ResourceLocation ammoId, GunData data) {
        AtomicReference<AmmoConfig> finalValue = new AtomicReference<AmmoConfig>(GunModifierHelper.getGun(data.gun).getFuelAmmoConfig(ammoId));
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyFuelAmmo((AmmoConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static Integer getMaxFuel(ResourceLocation type, GunData data) {
        Fuel fuel = GunModifierHelper.getFuel(type, data);
        int max = fuel != null ? fuel.getMax() : 0;
        AtomicReference<Integer> result = new AtomicReference<Integer>(max);
        GunModifierHelper.forEachAttachment(data, modifier -> result.set(modifier.modifyMaxFuel(type, (Integer)result.get(), data)));
        return result.get();
    }

    public static boolean isFuelMandatory(ResourceLocation ammoId, GunData data) {
        AtomicReference<Boolean> finalValue = new AtomicReference<Boolean>(GunModifierHelper.getGun(data.gun).getFuelConfig(ammoId).isMandatory());
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyIsFuelMandatory(ammoId, (Boolean)finalValue.get(), data)));
        return finalValue.get();
    }

    public static int getFuelAmountPerUse(ResourceLocation ammoId, GunData data) {
        AtomicReference<Integer> finalValue = new AtomicReference<Integer>(GunModifierHelper.getGun(data.gun).getFuelConfig(ammoId).getAmountPerUse());
        GunModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyFuelAmountPerUse(ammoId, (Integer)finalValue.get(), data)));
        return finalValue.get();
    }

    private static void forEachAttachment(GunData data, Consumer<IGunModifier> consumer) {
        ItemStack gun = data.gun;
        Gun config = GunModifierHelper.getGun(gun);
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> attachments = config.getModules().getAttachments();
        for (AttachmentType attachmentType : attachments.keySet()) {
            IGunModifier[] modifiers;
            ItemStack attachmentItem;
            data.attachment = attachmentItem = GunStateHelper.getAttachmentItem(attachmentType, gun);
            for (IGunModifier modifier : modifiers = GunModifierHelper.getAttachmentModifiers(attachmentItem)) {
                consumer.accept(modifier);
            }
        }
        WeaponItem gunItem = (WeaponItem)gun.m_41720_();
        for (IGunModifier modifier : gunItem.getGunModifiers()) {
            consumer.accept(modifier);
        }
    }

    private static IGunModifier[] getAttachmentModifiers(ItemStack attachmentItem) {
        Item item;
        if (!attachmentItem.m_41619_() && (item = attachmentItem.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            Object[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            Modifiers configModifiers = attachment.getAttachmentConfig().getModifiers();
            return (IGunModifier[])ArrayUtils.add((Object[])modifiers, (Object)configModifiers);
        }
        return EMPTY;
    }
}

