/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.world;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.data.config.ExplosionConfig;
import com.nukateam.ntgl.common.foundation.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator DEFAULT_CONTEXT = new ExplosionDamageCalculator();
    private final Level world;
    private final float radius;
    private final Entity exploder;
    private final ExplosionDamageCalculator context;
    private final float damage;
    private final float knockback;
    private final boolean damageDecreaseWithDistance;
    private final boolean causesFire;
    private final RandomSource random = RandomSource.m_216327_();
    private final Explosion.BlockInteraction blockInteraction;
    private final Vec3 pos;

    public ProjectileExplosion(Level world, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator context, ExplosionConfig projectile, Vec3 pos, Explosion.BlockInteraction mode) {
        super(world, exploder, source, context, pos.f_82479_, pos.f_82480_, pos.f_82481_, projectile.getRadius(), projectile.isCauseFire(), mode);
        this.world = world;
        this.causesFire = projectile.isCauseFire();
        this.blockInteraction = mode;
        this.pos = pos;
        this.radius = projectile.getRadius();
        this.exploder = exploder;
        this.context = context == null ? DEFAULT_CONTEXT : context;
        this.damage = projectile.getDamage();
        this.knockback = projectile.getKnockback();
        this.damageDecreaseWithDistance = projectile.isDamageReduceOverDistance();
    }

    public ProjectileExplosion(Level world, Entity exploder, ExplosionConfig projectile, Vec3 pos, Explosion.BlockInteraction mode, List<BlockPos> toBlow) {
        this(world, exploder, null, null, projectile, pos, mode);
        this.m_46081_().addAll(toBlow);
    }

    public void m_46061_() {
        this.destroyBlocks();
        double diameter = (double)this.radius * 2.0;
        int minX = Mth.m_14107_((double)(this.pos.f_82479_ - diameter - 1.0));
        int maxX = Mth.m_14107_((double)(this.pos.f_82479_ + diameter + 1.0));
        int minY = Mth.m_14107_((double)(this.pos.f_82480_ - diameter - 1.0));
        int maxY = Mth.m_14107_((double)(this.pos.f_82480_ + diameter + 1.0));
        int minZ = Mth.m_14107_((double)(this.pos.f_82481_ - diameter - 1.0));
        int maxZ = Mth.m_14107_((double)(this.pos.f_82481_ + diameter + 1.0));
        List entities = this.world.m_45933_(null, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)entities, (double)diameter);
        for (Entity entity : entities) {
            Player player;
            double deltaZ;
            double deltaY;
            double strength;
            if (entity.m_6128_() || (strength = Math.sqrt(entity.m_20238_(this.pos)) / diameter) > 1.0) continue;
            double deltaX = entity.m_20185_() - this.pos.f_82479_;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + (deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.pos.f_82480_) * deltaY + (deltaZ = entity.m_20189_() - this.pos.f_82481_) * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double blockDensity = ProjectileExplosion.m_46064_((Vec3)this.pos, (Entity)entity);
            double knockback = (1.0 - strength) * blockDensity * (double)this.knockback;
            float finalDamage = this.damage;
            if (this.damageDecreaseWithDistance) {
                finalDamage = (float)((double)finalDamage * (1.0 - strength));
            }
            entity.m_6469_(this.m_46077_(), finalDamage);
            if (entity instanceof LivingEntity) {
                knockback = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)knockback);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * knockback, deltaY * knockback, deltaZ * knockback));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(deltaX * knockback, deltaY * knockback, deltaZ * knockback));
        }
    }

    public void m_46075_(boolean pSpawnParticles) {
        if (this.world.f_46443_) {
            this.world.m_7785_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.f_46441_.m_188501_() - this.world.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean interactsWithBlocks = this.m_254884_();
        ObjectArrayList toBlow = (ObjectArrayList)this.m_46081_();
        if (pSpawnParticles) {
            if (!(this.radius < 2.0f) && interactsWithBlocks) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, 1.0, 0.0, 0.0);
            } else {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, 1.0, 0.0, 0.0);
            }
        }
        Boolean canBrakeGlass = (Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get();
        if (interactsWithBlocks || canBrakeGlass.booleanValue()) {
            ObjectArrayList blockDrops = new ObjectArrayList();
            boolean isPlayer = this.m_252906_() instanceof Player;
            Util.m_214673_((ObjectArrayList)toBlow, (RandomSource)this.world.f_46441_);
            for (BlockPos blockpos : toBlow) {
                Level level;
                BlockState blockState = this.world.m_8055_(blockpos);
                if (blockState.m_60795_() || (!canBrakeGlass.booleanValue() || !blockState.m_204336_(ModTags.Blocks.FRAGILE)) && !interactsWithBlocks) continue;
                BlockPos immutableBLockPos = blockpos.m_7949_();
                this.world.m_46473_().m_6180_("explosion_blocks");
                if (blockState.canDropFromExplosion((BlockGetter)this.world, blockpos, (Explosion)this) && (level = this.world) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockEntity blockEntity = blockState.m_155947_() ? this.world.m_7702_(blockpos) : null;
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)this.exploder);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockState.m_222967_(serverLevel, blockpos, ItemStack.f_41583_, isPlayer);
                    blockState.m_287290_(builder).forEach(p_46074_ -> ProjectileExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)blockDrops, p_46074_, immutableBLockPos));
                }
                blockState.onBlockExploded(this.world, blockpos, (Explosion)this);
                this.world.m_46473_().m_7238_();
            }
            for (Pair pair : blockDrops) {
                Block.m_49840_((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos2 : toBlow) {
                if (this.random.m_188503_(2) != 0 || !this.world.m_8055_(blockpos2).m_60795_() || !this.world.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.world, blockpos2.m_7495_())) continue;
                this.world.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.world, (BlockPos)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> pDropPositionArray, ItemStack pStack, BlockPos pPos) {
        int i = pDropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)pDropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)pStack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)pStack, (int)16);
            pDropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!pStack.m_41619_()) continue;
            return;
        }
        pDropPositionArray.add((Object)Pair.of((Object)pStack, (Object)pPos));
    }

    private void destroyBlocks() {
        HashSet set = Sets.newHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double d0 = (float)x / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)y / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)z / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.pos.f_82479_;
                    double blockY = this.pos.f_82480_;
                    double blockZ = this.pos.f_82481_;
                    for (float f = this.radius * (0.7f + this.world.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.225f) {
                        FluidState fluidState;
                        BlockState blockState;
                        BlockPos pos = BlockPos.m_274561_((double)blockX, (double)blockY, (double)blockZ);
                        Optional optional = this.context.m_6617_((Explosion)this, (BlockGetter)this.world, pos, blockState = this.world.m_8055_(pos), fluidState = this.world.m_6425_(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.m_6714_((Explosion)this, (BlockGetter)this.world, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)0.3f;
                        blockY += d1 * (double)0.3f;
                        blockZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
    }
}

