/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.handlers;

import com.nukateam.geo.render.ItemAnimator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class ClientTickHandler {
    private static final Map<ItemAnimator, Runnable> tickingAnimators = new HashMap<ItemAnimator, Runnable>();
    private static final Map<Object, Consumer<TickEvent>> tickers = new HashMap<Object, Consumer<TickEvent>>();

    public static void addTicker(ItemAnimator animator, Runnable onTick) {
        tickingAnimators.put(animator, onTick);
    }

    public static void addTicker(Object object, Consumer<TickEvent> onTick) {
        tickers.put(object, onTick);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            tickingAnimators.forEach((k, v) -> v.run());
        }
        tickers.forEach((k, v) -> v.accept(event));
    }
}

