/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class ScopeHud
implements IGuiOverlay {
    protected static final ResourceLocation SPYGLASS_SCOPE_LOCATION = new ResourceLocation("textures/misc/spyglass_scope.png");
    public static final IGuiOverlay SCOPE_HUD = new ScopeHud();
    private float scopeScale;

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack gun = player.m_21205_();
        float frameTime = minecraft.m_91297_();
        this.scopeScale = Mth.m_14179_((float)(0.5f * frameTime), (float)this.scopeScale, (float)1.125f);
        if (AimingHandler.isScoping(gun)) {
            ItemStack attachment = GunStateHelper.getAttachmentItem(AttachmentType.SCOPE, gun);
            if (!attachment.m_41619_()) {
                ScopeItem scope = GunStateHelper.getScopeItem(gun);
                ResourceLocation overlay = ((Scope)scope.getProperties()).getOverlay();
                this.setupOverlayRenderState(true);
                this.renderScope(graphics, width, height, overlay);
            }
        } else {
            this.scopeScale = 0.5f;
        }
    }

    private void renderScope(GuiGraphics graphics, int width, int height, ResourceLocation overlay) {
        float f = Math.min(width, height);
        float f1 = Math.min((float)width / f, (float)height / f) * this.scopeScale;
        int i = Mth.m_14143_((float)(f * f1));
        int j = Mth.m_14143_((float)(f * f1));
        int k = (width - i) / 2;
        int l = (height - j) / 2;
        int i1 = k + i;
        int j1 = l + j;
        graphics.m_280398_(overlay, k, l, -90, 0.0f, 0.0f, i, j, i, j);
        graphics.m_285795_(RenderType.m_286086_(), 0, j1, width, height, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), 0, 0, width, l, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), 0, l, k, j1, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), i1, l, width, j1, -90, -16777216);
    }

    public void setupOverlayRenderState(boolean blend) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
    }
}

