/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.weapon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.render.renderers.weapon.ArmedModelRenderer;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.data.attachment.impl.Barrel;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.attachment.BarrelItem;
import com.nukateam.ntgl.common.util.data.Rgba;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.model.GeoModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DynamicGunRenderer<Animator extends ItemAnimator>
extends ArmedModelRenderer<Animator> {
    public static final String MUZZLE_FLASH = "muzzle_flash";
    protected MultiBufferSource bufferSource;
    protected ArrayList<ItemStack> gunAttachments;
    protected ArrayList<Modules.Attachment> configAttachments;
    protected ArrayList<String> hiddenBones = new ArrayList();
    protected BarrelItem barrelItem;
    protected Gun gun;
    protected ItemStack gunStack;
    private ItemDisplayContext transformType;

    public DynamicGunRenderer(GeoModel<Animator> model) {
        super(model);
    }

    @Override
    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        BarrelItem barrel;
        this.bufferSource = bufferSource;
        this.transformType = transformType;
        this.gun = GunModifierHelper.getGun(stack);
        this.gunStack = stack;
        this.gunAttachments = GunStateHelper.getAttachmentItems(stack);
        this.configAttachments = this.gun.getAttachmentConfigs(this.gunAttachments);
        this.currentEntity = entity;
        if (TransformUtils.isFirstPerson(transformType) && AimingHandler.isScoping(stack)) {
            return;
        }
        ItemStack barrelStack = GunStateHelper.getAttachmentItem(AttachmentType.BARREL, stack);
        Item item = barrelStack.m_41720_();
        this.barrelItem = item instanceof BarrelItem ? (barrel = (BarrelItem)item) : null;
        this.prepareHiddenBones(transformType);
        poseStack.m_85836_();
        if (TransformUtils.isNonHand(transformType)) {
            poseStack.m_85837_(0.0, -0.46875, 0.0);
        } else if (TransformUtils.isFirstPerson(transformType)) {
            poseStack.m_85837_(0.0, -0.53125, 0.03125);
        } else {
            poseStack.m_85837_(0.0, -0.375, 0.0);
        }
        super.render(entity, stack, transformType, poseStack, bufferSource, renderType, buffer, packedLight);
        poseStack.m_85849_();
    }

    @Override
    public void renderRecursively(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.renderAttachments(bone);
        if (bone.getName().equals(MUZZLE_FLASH) && this.barrelItem != null) {
            this.renderMuzzleFlash(poseStack);
        }
        this.renderRecursivelyPost(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, new Rgba(red, green, blue, alpha));
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, this.bufferSource.m_6299_(renderType), isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    protected void renderRecursivelyPost(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, Rgba rgba) {
    }

    protected void renderAttachments(GeoBone bone) {
        String boneName = bone.getName();
        boolean hideBone = this.hiddenBones.stream().anyMatch(s -> s.equals(boneName));
        bone.setHidden(hideBone);
    }

    protected void renderMuzzleFlash(PoseStack poseStack) {
        float length = ((Barrel)this.barrelItem.getProperties()).getLength();
        poseStack.m_85837_(0.0, 0.0, (double)(-length) / 16.0);
        if (Ntgl.isDebugging()) {
            poseStack.m_85837_((double)(-ClientDebug.X) / 10.0 / 16.0, (double)ClientDebug.Y / 10.0 / 16.0, (double)ClientDebug.Z / 10.0 / 16.0);
        }
    }

    protected void prepareHiddenBones(ItemDisplayContext transformType) {
        if (this.gunStack == null || this.gunStack.m_41619_()) {
            return;
        }
        this.hiddenBones.clear();
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> gunAttachments = this.gun.getModules().getAttachments();
        ArrayList visibleBones = new ArrayList();
        gunAttachments.forEach((type, typeAttachments) -> {
            ItemStack item = GunStateHelper.getAttachmentItem(type, this.gunStack);
            for (Modules.Attachment attachment : typeAttachments) {
                if (this.shouldRenderAttachment(attachment, item)) {
                    if (transformType == ItemDisplayContext.GUI) continue;
                    this.hiddenBones.addAll(attachment.getHidden());
                    visibleBones.add(attachment.getName());
                    visibleBones.addAll(attachment.getBones());
                    continue;
                }
                this.hiddenBones.add(attachment.getName());
                this.hiddenBones.addAll(attachment.getBones());
            }
        });
        this.hiddenBones.removeAll(visibleBones);
    }

    protected boolean shouldRenderAttachment(Modules.Attachment attachment, ItemStack item) {
        if (this.transformType != ItemDisplayContext.GUI) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
            return !item.m_41619_() && attachment.getItemId().equals((Object)itemId);
        }
        return false;
    }
}

