/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.enums.SwayType;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.RecoilHandler;
import com.nukateam.ntgl.client.util.util.PropertyHelper;
import com.nukateam.ntgl.client.util.util.render.ModelRenderUtil;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.properties.SightAnimation;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.INtglItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GunRenderingHandler {
    private static GunRenderingHandler instance;
    public static final ResourceLocation GUI_ICONS_LOCATION;
    public static final ResourceLocation MUZZLE_FLASH_TEXTURE;
    private final Random random = new Random();
    private final Set<Integer> entityIdForMuzzleFlash = new HashSet<Integer>();
    private final Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    private final Map<Integer, Float> entityIdToRandomValue = new HashMap<Integer, Float>();
    private int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private float sprintIntensity;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float immersiveRoll;
    private float prevImmersiveRoll;
    private float fallSway;
    private float prevFallSway;
    private boolean usedConfiguredFov = true;
    @Nullable
    private ItemStack renderingWeapon;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
    }

    @Nullable
    public ItemStack getRenderingWeapon() {
        return this.renderingWeapon;
    }

    public void setUsedConfiguredFov(boolean value) {
        this.usedConfiguredFov = value;
    }

    public boolean getUsedConfiguredFov() {
        return this.usedConfiguredFov;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateOffhandTranslate();
        this.updateImmersiveCamera();
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.m_20142_() && !((Boolean)ModSyncedDataKeys.SHOOTING_RIGHT.getValue((Entity)mc.f_91074_)).booleanValue() && !((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)mc.f_91074_)).booleanValue() && !AimingHandler.get().isAiming() && this.sprintCooldown == 0) {
            if (this.sprintTransition < 5) {
                ++this.sprintTransition;
            }
        } else if (this.sprintTransition > 0) {
            --this.sprintTransition;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
    }

    private void updateMuzzleFlash() {
        this.entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(this.entityIdForMuzzleFlash);
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (heldItem.m_41720_() instanceof INtglItem) {
            down = GunStateHelper.getGripType(new GunData(heldItem, (LivingEntity)mc.f_91074_)).getHeldAnimation().canRenderOffhandItem();
        }
        float direction = down ? -0.3f : 0.3f;
        this.offhandTranslate = Mth.m_14036_((float)(this.offhandTranslate + direction), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        this.sprintTransition = 0;
        this.sprintCooldown = 20;
        ItemStack heldItem = event.getStack();
        WeaponItem gunItem = (WeaponItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getDisplay().getFlash() != null) {
            this.showMuzzleFlashForPlayer(Minecraft.m_91087_().f_91074_.m_19879_());
        }
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        this.entityIdForMuzzleFlash.add(entityId);
        this.entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onComputeFov(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof WeaponItem)) {
            return;
        }
        WeaponItem weaponItem = (WeaponItem)item;
        Gun modifiedGun = weaponItem.getModifiedGun(heldItem);
        if (!modifiedGun.canAimDownSight()) {
            return;
        }
        if (AimingHandler.get().getNormalisedAdsProgress() <= 0.0) {
            return;
        }
        double time = AimingHandler.get().getNormalisedAdsProgress();
        SightAnimation sightAnimation = PropertyHelper.getSightAnimations(heldItem);
        time = sightAnimation.getViewportCurve().apply(time);
        double viewportFov = PropertyHelper.getViewportFov(heldItem);
        double newFov = viewportFov > 0.0 ? viewportFov : event.getFOV();
        event.setFOV(Mth.m_14139_((double)time, (double)event.getFOV(), (double)newFov));
    }

    @SubscribeEvent
    public void onRenderOverlay(@NotNull RenderHandEvent event) {
        PoseStack poseStack = event.getPoseStack();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean isRight = minecraft.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? event.getHand() == InteractionHand.MAIN_HAND : event.getHand() == InteractionHand.OFF_HAND;
        ItemStack heldItem = event.getItemStack();
        InteractionHand hand = event.getHand();
        InteractionHand oppositeHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack oppositeStack = player.m_21120_(oppositeHand);
        if (!(hand != InteractionHand.OFF_HAND || GunStateHelper.isOneHanded(new GunData(heldItem, (LivingEntity)player)) && GunStateHelper.isOneHanded(new GunData(oppositeStack, (LivingEntity)player)))) {
            event.setCanceled(true);
            return;
        }
        if (heldItem.m_41720_() instanceof IWeapon || heldItem.m_41720_() instanceof IThrowable) {
            event.setCanceled(true);
            ItemStack overrideModel = ItemStack.f_41583_;
            if (heldItem.m_41783_() != null && heldItem.m_41783_().m_128425_("Model", 10)) {
                overrideModel = ItemStack.m_41712_((CompoundTag)heldItem.m_41783_().m_128469_("Model"));
            }
            BakedModel model = minecraft.m_91291_().m_174264_(overrideModel.m_41619_() ? heldItem : overrideModel, player.m_9236_(), (LivingEntity)player, 0);
            Vector3f rightHandTranslation = model.m_7442_().f_111790_.f_111756_;
            ItemDisplayContext transformType = isRight ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            poseStack.m_85836_();
            int offset = isRight ? 1 : -1;
            Item item = heldItem.m_41720_();
            if (item instanceof WeaponItem) {
                WeaponItem weaponItem = (WeaponItem)item;
                Gun modifiedGun = weaponItem.getModifiedGun(heldItem);
                Vector3f pos = model.m_7442_().f_111790_.f_111756_;
                this.applyIronSightTransforms(event, poseStack, model, isRight, heldItem, modifiedGun);
                this.applyAimingTransforms(poseStack, heldItem, modifiedGun, pos, offset);
                this.applySwayTransforms(poseStack, heldItem, player, rightHandTranslation, event.getPartialTick());
            }
            this.applyBobbingTransforms(poseStack, event.getPartialTick());
            float equipProgress = this.getEquipProgress(event.getPartialTick());
            poseStack.m_252880_(0.0f, equipProgress * -0.6f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(equipProgress * -50.0f));
            poseStack.m_85837_(0.15 * (double)offset, -1.0, -1.3);
            this.applyShieldTransforms(poseStack, player, heldItem, event.getPartialTick());
            this.renderWeapon((LivingEntity)player, heldItem, transformType, event.getPoseStack(), event.getMultiBufferSource(), this.getWeaponLghtning(event, player));
            poseStack.m_85849_();
        }
    }

    private Vec3 getArmTransforms(BakedModel model, InteractionHand hand) {
        ItemTransform handModel = hand == InteractionHand.MAIN_HAND ? model.m_7442_().f_111790_ : model.m_7442_().f_111789_;
        float translateX = handModel.f_111756_.x();
        float translateY = handModel.f_111756_.y();
        float translateZ = handModel.f_111756_.z();
        return new Vec3((double)translateX, (double)translateY, (double)translateZ);
    }

    private int getWeaponLghtning(RenderHandEvent event, LocalPlayer player) {
        int blockLight = player.m_6060_() ? 15 : player.m_9236_().m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)player.m_20299_(event.getPartialTick())));
        blockLight += this.entityIdForMuzzleFlash.contains(player.m_19879_()) ? 3 : 0;
        blockLight = Math.min(blockLight, 15);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)player.m_9236_().m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)player.m_20299_(event.getPartialTick()))));
        return packedLight;
    }

    private void applyIronSightTransforms(RenderHandEvent event, PoseStack poseStack, BakedModel model, boolean isRight, ItemStack heldItem, Gun modifiedGun) {
        float scaleX = model.m_7442_().f_111790_.f_111757_.x();
        float scaleY = model.m_7442_().f_111790_.f_111757_.y();
        float scaleZ = model.m_7442_().f_111790_.f_111757_.z();
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        float translateY = model.m_7442_().f_111790_.f_111756_.y();
        float translateZ = model.m_7442_().f_111790_.f_111756_.z();
        if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight() && event.getHand() == InteractionHand.MAIN_HAND) {
            double xOffset = translateX;
            double yOffset = translateY;
            double zOffset = translateZ;
            xOffset -= 0.5 * (double)scaleX;
            yOffset -= 0.5 * (double)scaleY;
            zOffset -= 0.5 * (double)scaleZ;
            Vec3 gunOrigin = PropertyHelper.getModelOrigin(heldItem, PropertyHelper.GUN_DEFAULT_ORIGIN);
            xOffset += gunOrigin.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += gunOrigin.f_82480_ * 0.0625 * (double)scaleY;
            zOffset += gunOrigin.f_82481_ * 0.0625 * (double)scaleZ;
            Vec3 ironSightCamera = PropertyHelper.getIronSightCamera(heldItem, modifiedGun).m_82546_(gunOrigin);
            xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY;
            zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ;
            if (PropertyHelper.isLegacyIronSight(heldItem)) {
                zOffset += 0.72;
            }
            float side = isRight ? 1.0f : -1.0f;
            double time = AimingHandler.get().getNormalisedAdsProgress();
            double transition = PropertyHelper.getSightAnimations(heldItem).getSightCurve().apply(time);
            poseStack.m_85837_(-0.56 * (double)side * transition, 0.52 * transition, 0.72 * transition);
            xOffset += 0.59375;
            yOffset += 0.45;
            zOffset += 0.34375;
            if (Ntgl.isDebugging()) {
                xOffset += (double)ClientDebug.X / 10.0 * 0.0625;
                yOffset += (double)ClientDebug.Y / 10.0 * 0.0625;
                zOffset += (double)ClientDebug.Z / 10.0 * 0.0625;
            }
            poseStack.m_85837_(-xOffset * (double)side * transition, -yOffset * transition, -zOffset * transition);
        }
    }

    private void applyBobbingTransforms(PoseStack poseStack, float partialTicks) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && (entity = mc.m_91288_()) instanceof Player) {
            Player player = (Player)entity;
            float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
            float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
            float bobbing = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f)));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f)));
            poseStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 0.5f)), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * bobbing))), 0.0);
            bobbing = (float)((double)bobbing * (player.m_20142_() ? 8.0 : 4.0));
            bobbing = (float)((double)bobbing * (Double)Config.CLIENT.display.bobbingIntensity.get());
            double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f * (float)invertZoomProgress));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f * (float)invertZoomProgress));
        }
    }

    private void applyAimingTransforms(PoseStack poseStack, ItemStack heldItem, Gun modifiedGun, Vector3f pos, int offset) {
        float x = pos.x();
        float y = pos.y();
        float z = pos.z();
        poseStack.m_252880_(x * (float)offset, y, z);
        poseStack.m_85837_(0.0, -0.25, 0.25);
        float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
        aiming = PropertyHelper.getSightAnimations(heldItem).getAimTransformCurve().apply(aiming);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(aiming * 10.0f * (float)offset));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(aiming * 5.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(aiming * 5.0f * (float)offset));
        poseStack.m_85837_(0.0, 0.25, -0.25);
        poseStack.m_252880_(-x * (float)offset, -y, -z);
    }

    private void applySwayTransforms(PoseStack poseStack, ItemStack heldItem, LocalPlayer player, Vector3f translation, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() && player != null) {
            poseStack.m_252880_(translation.x(), translation.y(), translation.z());
            double zOffset = GunModifierHelper.getGripType(new GunData(heldItem, (LivingEntity)player)).getHeldAnimation().getFallSwayZOffset();
            poseStack.m_85837_(0.0, -0.25, zOffset);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
            poseStack.m_85837_(0.0, 0.25, -zOffset);
            float bobPitch = Mth.m_14189_((float)partialTicks, (float)player.f_108588_, (float)player.f_108586_);
            float headPitch = Mth.m_14189_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
            float swayPitch = headPitch - bobPitch;
            swayPitch = (float)((double)swayPitch * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().m_252977_(swayPitch * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            float bobYaw = Mth.m_14189_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
            float headYaw = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
            float swayYaw = headYaw - bobYaw;
            swayYaw = (float)((double)swayYaw * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().m_252977_(swayYaw * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            poseStack.m_252880_(-translation.x(), -translation.y(), -translation.z());
        }
    }

    private void applyReloadTransforms(PoseStack poseStack, float partialTicks) {
        float reloadProgress = ClientReloadHandler.get().getReloadProgress(partialTicks);
        poseStack.m_85837_(0.0, 0.35 * (double)reloadProgress, 0.0);
        poseStack.m_85837_(0.0, 0.0, -0.1 * (double)reloadProgress);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f * reloadProgress));
    }

    private void applyRecoilTransforms(PoseStack poseStack, Player player, ItemStack item, Gun gun) {
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (GunStateHelper.hasAttachmentEquipped(item, AttachmentType.SCOPE)) {
            recoilNormal -= recoilNormal * (0.5 * AimingHandler.get().getNormalisedAdsProgress());
        }
        GunData data = new GunData(item, (LivingEntity)player);
        float kickReduction = 1.0f - GunModifierHelper.getKickReduction(data);
        float recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(data);
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(RecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        poseStack.m_85837_(0.0, 0.0, kick * (double)kickReduction);
        poseStack.m_85837_(0.0, 0.0, 0.15);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(recoilSway * recoilReduction));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(recoilSway * recoilReduction));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(recoilLift * recoilReduction));
        poseStack.m_85837_(0.0, 0.0, -0.15);
    }

    private void applyShieldTransforms(PoseStack poseStack, LocalPlayer player, ItemStack stack, float partialTick) {
        if (player.m_6117_() && player.m_21206_().m_41720_() == Items.f_42740_ && GunStateHelper.isOneHanded(new GunData(stack, (LivingEntity)player))) {
            double time = Mth.m_14008_((double)((float)player.m_21252_() + partialTick), (double)0.0, (double)4.0) / 4.0;
            poseStack.m_85837_(0.0, 0.35 * time, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f * (float)time));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
    }

    public void applyWeaponScale(ItemStack heldItem, PoseStack stack) {
        CompoundTag compound;
        if (heldItem.m_41783_() != null && (compound = heldItem.m_41783_()).m_128425_("Scale", 5)) {
            float scale = compound.m_128457_("Scale");
            stack.m_85841_(scale, scale, scale);
        }
    }

    public void renderWeapon(@Nullable LivingEntity entity, ItemStack renderStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Item item = renderStack.m_41720_();
        if (item instanceof DynamicGeoItem) {
            DynamicGeoItem weaponItem = (DynamicGeoItem)item;
            poseStack.m_85836_();
            ItemStack model = ItemStack.f_41583_;
            if (renderStack.m_41783_() != null && renderStack.m_41783_().m_128425_("Model", 10)) {
                model = ItemStack.m_41712_((CompoundTag)renderStack.m_41783_().m_128469_("Model"));
            }
            ModelRenderUtil.applyTransformType(renderStack, poseStack, transformType, entity);
            this.renderingWeapon = renderStack;
            weaponItem.getRenderer().render(entity, model.m_41619_() ? renderStack : model, transformType, poseStack, bufferSource, null, null, packedLight);
            this.renderingWeapon = null;
            poseStack.m_85849_();
        }
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109302_");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109303_");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        ItemInHandRenderer firstPersonRenderer = Minecraft.m_91087_().m_91290_().m_234586_();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - Mth.m_14179_((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private void updateImmersiveCamera() {
        this.prevImmersiveRoll = this.immersiveRoll;
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        float targetAngle = heldItem.m_41720_() instanceof WeaponItem || (Boolean)Config.CLIENT.display.restrictCameraRollToWeapons.get() == false ? mc.f_91074_.f_108618_.f_108566_ : 0.0f;
        float speed = mc.f_91074_.f_108618_.f_108566_ != 0.0f ? 0.1f : 0.15f;
        this.immersiveRoll = Mth.m_14179_((float)speed, (float)this.immersiveRoll, (float)targetAngle);
        float deltaY = (float)Mth.m_14008_((double)(mc.f_91074_.f_19855_ - mc.f_91074_.m_20186_()), (double)-1.0, (double)1.0);
        deltaY = (float)((double)deltaY * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        deltaY = (float)((double)deltaY * (1.0 - (double)(Mth.m_14154_((float)mc.f_91074_.m_146909_()) / 90.0f)));
        this.fallSway = Mth.m_14121_((float)this.fallSway, (float)(deltaY * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
        float intensity = mc.f_91074_.m_20142_() ? 0.75f : 1.0f;
        this.sprintIntensity = Mth.m_14121_((float)this.sprintIntensity, (float)intensity, (float)0.1f);
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (((Boolean)Config.CLIENT.display.cameraRollEffect.get()).booleanValue() && this.prevImmersiveRoll != 0.0f && this.immersiveRoll != 0.0f) {
            float roll = (float)Mth.m_14139_((double)event.getPartialTick(), (double)this.prevImmersiveRoll, (double)this.immersiveRoll);
            roll = (float)Math.sin((double)roll * Math.PI / 2.0);
            event.setRoll(-(roll *= ((Double)Config.CLIENT.display.cameraRollAngle.get()).floatValue()));
        }
    }

    static {
        GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
        MUZZLE_FLASH_TEXTURE = ResourceLocation.m_214293_((String)"ntgl", (String)"textures/effect/muzzle_flash.png");
    }
}

