/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.pose.AimPose;
import com.nukateam.ntgl.client.util.pose.LimbPose;
import com.nukateam.ntgl.client.util.pose.WeaponPose;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class HammerPose
extends WeaponPose {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHumanoidModelRotation(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        boolean right;
        super.applyHumanoidModelRotation(entity, rightArm, leftArm, head, hand, aimProgress);
        boolean bl = right = hand == InteractionHand.MAIN_HAND;
        if (!right) {
            return;
        }
        leftArm.f_104203_ += (float)Math.toRadians(ClientDebug.X);
        leftArm.f_104204_ += (float)Math.toRadians(ClientDebug.Y);
        leftArm.f_104205_ += (float)Math.toRadians(ClientDebug.Z);
        if (entity.m_21211_().m_41720_() == Items.f_42740_) {
            rightArm.f_104203_ = (float)Math.toRadians(-30.0);
        }
    }

    @Override
    protected AimPose getUpPose() {
        AimPose upPose = new AimPose();
        upPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(60.0f, 0.0f, 10.0f)).setRightArm(new LimbPose().setRotationAngleX(-115.0f).setRotationAngleY(-60.0f).setRotationAngleZ(-50.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-130.0f).setRotationAngleY(-25.0f).setRotationAngleZ(-60.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        return upPose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose forwardPose = new AimPose();
        forwardPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(30.0f, -11.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(-15.0f).setRotationAngleZ(-35.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f).setRotationPointZ(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(55.0f).setRotationAngleZ(-25.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        return forwardPose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose downPose = new AimPose();
        downPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-15.0f, -5.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 0.5f)).setRightArm(new LimbPose().setRotationAngleX(-40.0f).setRotationAngleY(-5.0f).setRotationAngleZ(-40.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-5.0f).setRotationAngleY(30.0f).setRotationAngleZ(30.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        return downPose;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyGeoModelRotation(LivingEntity entity, CoreGeoBone rightArm, CoreGeoBone leftArm, CoreGeoBone head, InteractionHand interactionHand) {
        try {
            boolean right = interactionHand == InteractionHand.MAIN_HAND;
            CoreGeoBone arm = right ? rightArm : leftArm;
            arm.setRotX(head.getRotX());
            arm.setRotY(head.getRotY());
            arm.setRotZ(head.getRotZ());
            arm.setRotX(head.getRotX() + 70.0f);
        }
        catch (Exception e) {
            Ntgl.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void applyHeldItemTransforms(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        int side = hand == InteractionHand.OFF_HAND ? 1 : -1;
        poseStack.m_85837_(0.45 * (double)side, -0.5, -1.2);
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        int leftHanded = right ? 1 : -1;
        poseStack.m_85837_(-0.125, -0.1875, -0.0625);
    }

    @Override
    public boolean applyOffhandTransforms(LivingEntity entity, HumanoidModel<LivingEntity> model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (entity.m_6047_()) {
            poseStack.m_85837_(-0.28125, -0.9375, -0.25);
        } else if (!entity.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
            poseStack.m_85837_(-0.25, -0.8125, 0.0625);
        } else {
            poseStack.m_85837_(-0.21875, -0.8125, 0.0625);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(75.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(Math.toDegrees(model.f_102813_.f_104203_) / 10.0)));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }

    @Override
    public boolean canRenderOffhandItem() {
        return true;
    }

    @Override
    public double getFallSwayZOffset() {
        return 0.5;
    }
}

