/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.util;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerAnimationHelper;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerAnimations {
    public static void playFireAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            GunData gunData = new GunData(player.m_21120_(hand), (LivingEntity)Minecraft.m_91087_().f_91074_);
            int rate = GunModifierHelper.getRate(gunData);
            ResourceLocation animation = GunModifierHelper.getAnimation(AnimationType.FIRE, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), animation, rate, hand == InteractionHand.OFF_HAND);
        }
    }

    public static void playMeleeAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            GunData gunData = new GunData(player.m_21120_(hand), (LivingEntity)Minecraft.m_91087_().f_91074_);
            int delay = GunModifierHelper.getMeleeDelay(gunData);
            int cooldown = GunModifierHelper.getMeleeCooldown(gunData);
            ResourceLocation animation = GunModifierHelper.getAnimation(AnimationType.MELEE, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), animation, delay + cooldown, hand == InteractionHand.OFF_HAND);
        }
    }

    public static void playReloadAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            int reloadDuration = 0;
            GunData gunData = new GunData(player.m_21120_(hand), (LivingEntity)player);
            int reloadTime = GunModifierHelper.getReloadTime(gunData);
            LoadingType loadingType = GunModifierHelper.getLoadingType(gunData);
            if (loadingType.equals(LoadingType.PER_CARTRIDGE)) {
                int ammoCount = GunModifierHelper.getMaxAmmo(gunData) - GunStateHelper.getAmmoCount(gunData);
                for (int i = 0; i < ammoCount; ++i) {
                    reloadDuration += reloadTime;
                }
            } else {
                reloadDuration = reloadTime;
            }
            ResourceLocation reloadAnimation = GunModifierHelper.getAnimation(AnimationType.RELOAD, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), reloadAnimation, reloadDuration, hand == InteractionHand.OFF_HAND);
        }
    }
}

