/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.gun;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.gun.Positioned;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class Display
implements INBTSerializable<CompoundTag> {
    @Optional
    @Nullable
    protected Flash flash;

    @Nullable
    public Flash getFlash() {
        return this.flash;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.flash != null) {
            tag.m_128365_("Flash", (Tag)this.flash.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Flash", 10)) {
            CompoundTag flashTag = tag.m_128469_("Flash");
            if (!flashTag.m_128456_()) {
                Flash flash = new Flash();
                flash.deserializeNBT(tag.m_128469_("Flash"));
                this.flash = flash;
            } else {
                this.flash = null;
            }
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        if (this.flash != null) {
            GunJsonUtil.addObjectIfNotEmpty(object, "flash", this.flash.toJsonObject());
        }
        return object;
    }

    public Display copy() {
        Display display = new Display();
        if (this.flash != null) {
            display.flash = this.flash.copy();
        }
        return display;
    }

    public static class Flash
    extends Positioned {
        double size = 0.5;

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("Size", this.size);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Size", 99)) {
                this.size = tag.m_128459_("Size");
            }
        }

        @Override
        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.size >= 0.0 ? 1 : 0) != 0, (Object)"Muzzle flash size must be more than or equal to zero");
            JsonObject object = super.toJsonObject();
            if (this.size != 0.5) {
                object.addProperty("size", (Number)this.size);
            }
            return object;
        }

        @Override
        public Flash copy() {
            Flash flash = new Flash();
            flash.size = this.size;
            flash.xOffset = this.xOffset;
            flash.yOffset = this.yOffset;
            flash.zOffset = this.zOffset;
            return flash;
        }

        public double getSize() {
            return this.size;
        }
    }
}

