/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.google.gson.JsonParseException;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class AnimationType
extends ResourceHolder {
    public static final AnimationType FIRE = new AnimationType("fire");
    public static final AnimationType RELOAD = new AnimationType("reload");
    public static final AnimationType MELEE = new AnimationType("melee");
    private static final Map<ResourceLocation, AnimationType> typeMap = new HashMap<ResourceLocation, AnimationType>();
    private BiConsumer<Player, InteractionHand> animation;

    public static void register() {
        AnimationType.registerType(FIRE);
        AnimationType.registerType(RELOAD);
        AnimationType.registerType(MELEE);
    }

    public AnimationType(ResourceLocation id) {
        super(id);
        this.animation = this.animation;
    }

    private AnimationType(String name) {
        this(ResourceLocation.m_214293_((String)"ntgl", (String)name));
    }

    public void setAnimation(BiConsumer<Player, InteractionHand> animation) {
        this.animation = animation;
    }

    public void playAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            this.animation.accept(player, hand);
        }
    }

    public static void registerType(AnimationType mode) {
        typeMap.putIfAbsent(mode.getId(), mode);
    }

    public static AnimationType getType(ResourceLocation id) {
        AnimationType type = typeMap.get(id);
        if (type == null) {
            throw new JsonParseException("Animation type \"" + id.toString() + "\" doesn't exists");
        }
        return type;
    }

    public static AnimationType getType(String id) {
        return AnimationType.getType(ResourceLocation.m_135820_((String)id));
    }
}

