/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.client.util.util.Easings;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoType;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.CounterType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.MeleeMode;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class JsonDeserializers {
    public static final JsonDeserializer<ItemStack> ITEM_STACK = (json, typeOfT, context) -> CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(), (boolean)true);
    public static final JsonDeserializer<FireMode> FIRE_MODE = (json, typeOfT, context) -> FireMode.getType(ResourceLocation.m_135820_((String)json.getAsString()));
    public static final JsonDeserializer<AttachmentType> ATTACHMENT_TYPE = (json, typeOfT, context) -> AttachmentType.getType(ResourceLocation.m_135820_((String)json.getAsString()));
    public static final JsonDeserializer<AmmoType> AMMO_TYPE = (json, typeOfT, context) -> AmmoType.getType(ResourceLocation.m_135820_((String)json.getAsString()));
    public static final JsonDeserializer<ProjectileType> PROJECTILE_TYPE = (json, typeOfT, context) -> ProjectileType.getType(json.getAsString());
    public static final JsonDeserializer<ResourceLocation> RESOURCE_LOCATION = (json, typeOfT, context) -> ResourceLocation.m_135820_((String)json.getAsString());
    public static final JsonDeserializer<GripType> GRIP_TYPE = (json, typeOfT, context) -> GripType.getType(ResourceLocation.m_135820_((String)json.getAsString()));
    public static final JsonDeserializer<LoadingType> LOADING_TYPE = (json, typeOfT, context) -> LoadingType.getType(json.getAsString());
    public static final JsonDeserializer<WeaponMode> WEAPON_MODE = (json, typeOfT, context) -> WeaponMode.getType(json.getAsString());
    public static final JsonDeserializer<MeleeMode> MELEE_MODE = (json, typeOfT, context) -> MeleeMode.getType(json.getAsString());
    public static final JsonDeserializer<ThrowMode> GRENADE_MODE = (json, typeOfT, context) -> ThrowMode.getType(json.getAsString());
    public static final JsonDeserializer<AmmoHolder> SECONDARY_AMMO_TYPE = (json, typeOfT, context) -> AmmoHolder.getType(json.getAsString());
    public static final JsonDeserializer<CounterType> COUNTER_TYPE = (json, typeOfT, context) -> CounterType.getType(json.getAsString());
    public static final JsonDeserializer<AnimationType> ANIMATION_TYPE = (json, typeOfT, context) -> AnimationType.getType(json.getAsString());
    public static final JsonDeserializer<ResourceKey<DamageType>> DAMAGE_TYPE = (json, typeOfT, context) -> JsonDeserializers.getDamageTypeResourceKey(json.getAsString());
    public static final JsonDeserializer<Easings> EASING = (json, typeOfT, context) -> Easings.byName(json.getAsString());
    public static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, RESOURCE_LOCATION);
        builder.registerTypeAdapter(GripType.class, GRIP_TYPE);
        builder.registerTypeAdapter(LoadingType.class, LOADING_TYPE);
        builder.registerTypeAdapter(WeaponMode.class, WEAPON_MODE);
        builder.registerTypeAdapter(MeleeMode.class, MELEE_MODE);
        builder.registerTypeAdapter(ThrowMode.class, GRENADE_MODE);
        builder.registerTypeAdapter(AmmoHolder.class, SECONDARY_AMMO_TYPE);
        builder.registerTypeAdapter(FireMode.class, FIRE_MODE);
        builder.registerTypeAdapter(AttachmentType.class, ATTACHMENT_TYPE);
        builder.registerTypeAdapter(AmmoType.class, AMMO_TYPE);
        builder.registerTypeAdapter(ProjectileType.class, PROJECTILE_TYPE);
        builder.registerTypeAdapter(Easings.class, EASING);
        builder.registerTypeAdapter(ResourceKey.class, DAMAGE_TYPE);
        builder.registerTypeAdapter(CounterType.class, COUNTER_TYPE);
        builder.registerTypeAdapter(AnimationType.class, ANIMATION_TYPE);
        builder.excludeFieldsWithModifiers(new int[]{128});
        return builder.create();
    });

    @NotNull
    public static ResourceKey<DamageType> getDamageTypeResourceKey(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.m_135820_((String)id));
    }
}

