/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.crafting;

import com.google.common.collect.ImmutableList;
import com.nukateam.ntgl.common.foundation.blockentity.WorkbenchBlockEntity;
import com.nukateam.ntgl.common.foundation.crafting.ModRecipeType;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.foundation.init.ModRecipeSerializers;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class WorkbenchRecipe
implements Recipe<WorkbenchBlockEntity> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<WorkbenchIngredient> materials;

    public WorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<WorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.m_41777_();
    }

    public ImmutableList<WorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(WorkbenchBlockEntity inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(WorkbenchBlockEntity entity, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.item.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.WORKBENCH.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeType.WORKBENCH.get();
    }

    public boolean hasMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            if (InventoryUtil.hasWorkstationIngredient(player, ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            InventoryUtil.removeWorkstationIngredient(player, ingredient);
        }
    }
}

