/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;

public class S2CMessageProjectileHitBlock
extends PlayMessage<S2CMessageProjectileHitBlock> {
    private double x;
    private double y;
    private double z;
    private BlockPos pos;
    private Direction face;

    public S2CMessageProjectileHitBlock() {
    }

    public S2CMessageProjectileHitBlock(double x, double y, double z, BlockPos pos, Direction face) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pos = pos;
        this.face = face;
    }

    public void encode(S2CMessageProjectileHitBlock message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
        buffer.m_130064_(message.pos);
        buffer.m_130068_((Enum)message.face);
    }

    public S2CMessageProjectileHitBlock decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        BlockPos pos = buffer.m_130135_();
        Direction face = (Direction)buffer.m_130066_(Direction.class);
        return new S2CMessageProjectileHitBlock(x, y, z, pos, face);
    }

    public void handle(S2CMessageProjectileHitBlock message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleProjectileHitBlock(message));
        supplier.setHandled(true);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getFace() {
        return this.face;
    }
}

