/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.managers;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableGrenadeEntity;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.util.interfaces.IProjectileFactory;
import com.nukateam.ntgl.common.util.interfaces.IThrowableProjectileFactory;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (level, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)Projectiles.PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private final IThrowableProjectileFactory DEFAULT_THROWABLE_FACTORY = ThrowableGrenadeEntity::new;
    private final Map<ResourceLocation, IProjectileFactory> projectileForAmmoFactories = new HashMap<ResourceLocation, IProjectileFactory>();
    private final Map<ResourceLocation, IProjectileFactory> projectileForTypeFactories = new HashMap<ResourceLocation, IProjectileFactory>();
    private final Map<ResourceLocation, IThrowableProjectileFactory> throwableProjectileFactories = new HashMap<ResourceLocation, IThrowableProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(ProjectileType ammo, IThrowableProjectileFactory factory) {
        this.throwableProjectileFactories.put(ammo.getId(), factory);
    }

    public void registerFactory(ProjectileType ammo, IProjectileFactory factory) {
        this.projectileForTypeFactories.put(ammo.getId(), factory);
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileForAmmoFactories.put(ForgeRegistries.ITEMS.getKey((Object)ammo), factory);
    }

    public IProjectileFactory getFactory(GunData data) {
        AmmoHolder item = GunStateHelper.getCurrentAmmo(data);
        ProjectileType projectileType = GunStateHelper.getProjectileConfig(data).getProjectile();
        IProjectileFactory factory = this.projectileForAmmoFactories.get(item);
        if (this.projectileForAmmoFactories.containsKey(item)) {
            return this.projectileForAmmoFactories.get(item);
        }
        factory = this.projectileForTypeFactories.get(projectileType.getId());
        if (factory != null) {
            return factory;
        }
        return this.DEFAULT_FACTORY;
    }

    public IThrowableProjectileFactory getFactory(ProjectileType projectileType) {
        IThrowableProjectileFactory factory = this.throwableProjectileFactories.get(projectileType.getId());
        if (factory != null) {
            return factory;
        }
        return this.DEFAULT_THROWABLE_FACTORY;
    }
}

