/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack;

import com.google.gson.Gson;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.json.JsonDeserializers;
import com.nukateam.ntgl.common.util.annotation.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DataUtils {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();

    @NotNull
    public static <T, Y> Map<T, Y> getConfigMap(ResourceManager manager, Function<Item, Boolean> tClass, Class<Y> yClass, String resourcePath) {
        HashMap map = new HashMap();
        ForgeRegistries.ITEMS.getValues().stream().filter(tClass::apply).forEach(item -> {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            if (id != null) {
                ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>(DataUtils.getJsonResources(manager, resourcePath, id).keySet());
                resources.sort((r1, r2) -> {
                    if (r1.m_135827_().equals(r2.m_135827_())) {
                        return 0;
                    }
                    return r2.m_135827_().equals("ntgl") ? 1 : -1;
                });
                resources.forEach(resourceLocation -> {
                    String path = resourceLocation.m_135815_().substring(0, resourceLocation.m_135815_().length() - FILE_TYPE_LENGTH_VALUE);
                    String[] splitPath = path.split("/");
                    if (!id.m_135815_().equals(splitPath[splitPath.length - 1])) {
                        return;
                    }
                    if (!id.m_135827_().equals(resourceLocation.m_135827_())) {
                        return;
                    }
                    manager.m_213713_(resourceLocation).ifPresent(resource -> {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8));){
                            Object gun = GsonHelper.m_13776_((Gson)JsonDeserializers.GSON_INSTANCE, (Reader)reader, (Class)yClass);
                            if (Validator.isValidObject(gun)) {
                                map.put(item, gun);
                            } else {
                                Ntgl.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default gun data", resourceLocation);
                                map.putIfAbsent(item, yClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            }
                        }
                        catch (InvalidObjectException e) {
                            Ntgl.LOGGER.error("Missing required properties for {}", resourceLocation);
                            e.printStackTrace();
                        }
                        catch (IOException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            Ntgl.LOGGER.error("Couldn't parse data file {}", resourceLocation);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
        });
        return map;
    }

    @NotNull
    private static Map<ResourceLocation, Resource> getJsonResources(ResourceManager manager, String path, ResourceLocation id) {
        return manager.m_214159_(path, fileName -> fileName.m_135815_().endsWith(id.m_135815_() + ".json"));
    }
}

