/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.managers;

import com.google.common.collect.ImmutableMap;
import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.foundation.item.IChassisEquipment;
import com.nukateam.chassis_core.common.network.managers.ConfigSupplier;
import com.nukateam.chassis_core.common.network.managers.Configs;
import com.nukateam.chassis_core.modules.config.utils.ConfigUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkEquipmentManager
extends SimplePreparableReloadListener<Map<IChassisEquipment, EquipmentConfig>> {
    public static final String PATH = "cc/equipment";
    private static NetworkEquipmentManager instance;
    private Map<ResourceLocation, EquipmentConfig> registeredConfig = new HashMap<ResourceLocation, EquipmentConfig>();

    private NetworkEquipmentManager() {
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkEquipmentManager networkGunManager = new NetworkEquipmentManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    protected Map<IChassisEquipment, EquipmentConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return ConfigUtils.getConfigMap(manager, ForgeRegistries.ITEMS, v -> true, EquipmentConfig.class, PATH);
    }

    protected void apply(Map<IChassisEquipment, EquipmentConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, config) -> {
            Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)));
            builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)), config);
            item.setConfig(new ConfigSupplier<EquipmentConfig>((EquipmentConfig)config));
            Configs.EQUIPMENT_CONFIGS.put((IChassisEquipment)item, new ConfigSupplier<EquipmentConfig>((EquipmentConfig)config));
        });
        this.registeredConfig = builder.build();
    }

    public void writeRegisteredConfig(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredConfig.size());
        this.registeredConfig.forEach((id, config) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(config.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, EquipmentConfig> readRegisteredConfigs(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                EquipmentConfig config = EquipmentConfig.create(buffer.m_130260_());
                builder.put((Object)id, (Object)config);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredConfig(Map<ResourceLocation, EquipmentConfig> registeredConfig) {
        if (registeredConfig != null) {
            for (Map.Entry<ResourceLocation, EquipmentConfig> entry : registeredConfig.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                Configs.EQUIPMENT_CONFIGS.put((IChassisEquipment)item, new ConfigSupplier<EquipmentConfig>(entry.getValue()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static NetworkEquipmentManager get() {
        return instance;
    }

    public static void stop() {
        instance = null;
    }
}

