/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.packet;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class S2CInventoryPacket
extends PlayMessage<S2CInventoryPacket> {
    public int chassisId = -1;
    public ListTag inventory;
    public static final String INVENTORY = "inventory";

    public S2CInventoryPacket() {
    }

    public S2CInventoryPacket(int chassisId, ListTag inventory) {
        this.chassisId = chassisId;
        this.inventory = inventory;
    }

    public void encode(S2CInventoryPacket message, FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(INVENTORY, (Tag)message.inventory);
        buffer.writeInt(message.chassisId);
        buffer.m_130079_(nbt);
    }

    public S2CInventoryPacket decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        ListTag inventory = (ListTag)buffer.m_130260_().m_128423_(INVENTORY);
        return new S2CInventoryPacket(entityId, inventory);
    }

    public void handle(S2CInventoryPacket message, MessageContext supplier) {
        supplier.execute(() -> {
            Entity entity;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (entity = player.m_9236_().m_6815_(message.chassisId)) instanceof WearableChassis) {
                WearableChassis powerArmor = (WearableChassis)entity;
                powerArmor.setArmorData(message.inventory);
            }
        });
        supplier.setHandled(true);
    }
}

