/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl;

import com.mojang.logging.LogUtils;
import com.nukateam.chassis_core.ChassisCore;
import com.nukateam.example.common.registery.EntityTypes;
import com.nukateam.example.common.registery.ExampleWeapons;
import com.nukateam.example.common.registery.ModItemTabs;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.client.settings.NtglOptions;
import com.nukateam.ntgl.client.util.handler.CrosshairHandler;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.datagen.BlockTagGen;
import com.nukateam.ntgl.common.datagen.ItemTagGen;
import com.nukateam.ntgl.common.datagen.LootTableGen;
import com.nukateam.ntgl.common.datagen.RecipeGen;
import com.nukateam.ntgl.common.foundation.crafting.ModRecipeType;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.foundation.init.ModContainers;
import com.nukateam.ntgl.common.foundation.init.ModEffects;
import com.nukateam.ntgl.common.foundation.init.ModEntityTypes;
import com.nukateam.ntgl.common.foundation.init.ModParticleTypes;
import com.nukateam.ntgl.common.foundation.init.ModRecipeSerializers;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.init.ModTileEntities;
import com.nukateam.ntgl.common.foundation.init.NtglDamageTypes;
import com.nukateam.ntgl.common.foundation.init.NtglGameEvents;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.registry.AmmoHolders;
import com.nukateam.ntgl.common.registry.ProjectileRegistry;
import com.nukateam.ntgl.common.util.managers.BoundingBoxManager;
import com.nukateam.ntgl.modules.gunpack.GunPackModule;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="ntgl")
public class Ntgl {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "ntgl";
    public static final IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
    public static boolean controllableLoaded = false;
    public static boolean backpackedLoaded = false;
    public static boolean sophisticatedLoaded = false;
    public static boolean travelersLoaded = false;
    public static boolean yyzBackpackLoaded = false;
    public static boolean curiosLoaded = false;
    public static boolean playerReviveLoaded = false;
    public static boolean playerAnimatorLoaded = false;
    public static boolean subtleEffectsLoaded = false;
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_268580_, NtglDamageTypes::bootstrap);

    public Ntgl() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        ModContainers.REGISTER.register(MOD_EVENT_BUS);
        ModEffects.REGISTER.register(MOD_EVENT_BUS);
        Projectiles.REGISTER.register(MOD_EVENT_BUS);
        if (Ntgl.isDebugging()) {
            ModItemTabs.register(MOD_EVENT_BUS);
        }
        ExampleWeapons.register(MOD_EVENT_BUS);
        ModRecipeType.REGISTER.register(MOD_EVENT_BUS);
        ModParticleTypes.REGISTER.register(MOD_EVENT_BUS);
        ModRecipeSerializers.REGISTER.register(MOD_EVENT_BUS);
        ModSounds.REGISTER.register(MOD_EVENT_BUS);
        ModTileEntities.REGISTER.register(MOD_EVENT_BUS);
        ModEntityTypes.register(MOD_EVENT_BUS);
        EntityTypes.register(MOD_EVENT_BUS);
        MOD_EVENT_BUS.addListener(this::onCommonSetup);
        MOD_EVENT_BUS.addListener(this::onClientSetup);
        MOD_EVENT_BUS.addListener(this::onGatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MOD_EVENT_BUS.addListener(NtglKeyBinds::registerKeyMappings);
            MOD_EVENT_BUS.addListener(CrosshairHandler::onConfigReload);
        });
        GunPackModule.init(MOD_EVENT_BUS);
        NtglGameEvents.register(MOD_EVENT_BUS);
        new ChassisCore(MOD_EVENT_BUS);
        curiosLoaded = ModList.get().isLoaded("curios");
        controllableLoaded = ModList.get().isLoaded("controllable");
        backpackedLoaded = ModList.get().isLoaded("backpacked");
        sophisticatedLoaded = ModList.get().isLoaded("sophisticatedbackpacks");
        travelersLoaded = ModList.get().isLoaded("travelersbackpack");
        yyzBackpackLoaded = ModList.get().isLoaded("yyzsbackpack");
        playerReviveLoaded = ModList.get().isLoaded("playerrevive");
        playerAnimatorLoaded = ModList.get().isLoaded("playeranimator");
        subtleEffectsLoaded = ModList.get().isLoaded("subtle_effects");
        AmmoHolders.register();
        AnimationType.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isDebugging() {
        return !FMLEnvironment.production;
    }

    public static NtglOptions getOptions() {
        return NtglOptions.getInstance();
    }

    public static ResourceLocation ntglResource(String name) {
        return ResourceLocation.m_214293_((String)MOD_ID, (String)name);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketHandler.init();
            ModSyncedDataKeys.register();
            CraftingHelper.register((ResourceLocation)new ResourceLocation(MOD_ID, "workbench_ingredient"), (IIngredientSerializer)WorkbenchIngredient.Serializer.INSTANCE);
            ProjectileRegistry.registerProjectiles();
            if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
                MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
            }
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientHandler::setup);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagGen blockTagGen = new BlockTagGen(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagGen);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGen(output, lookupProvider, blockTagGen.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), BUILDER, Set.of(MOD_ID)));
    }
}

