/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.nukateam.ntgl.ClientProxy;
import com.nukateam.ntgl.common.foundation.entity.FlyingGib;
import com.nukateam.ntgl.common.foundation.entity.projectile.GoreData;
import com.nukateam.ntgl.common.util.data.Rgba;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class FlyingGibsRenderer
extends EntityRenderer<FlyingGib> {
    public static final int MAX_DEATH_TIME = 20;

    public FlyingGibsRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(FlyingGib flyingGib, float pEntityYaw, float pPartialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity entity = flyingGib.getLocalEntity();
        if (entity == null) {
            return;
        }
        GoreData data = flyingGib.getData();
        boolean isGeoModel = false;
        if (data.model != null) {
            poseStack.m_85836_();
            EntityRenderer render = ClientProxy.getEntityRenderer((Entity)entity);
            if (render instanceof LivingEntityRenderer) {
                try {
                    if (data.texture == null) {
                        data.texture = render.m_5478_((Entity)entity);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (render instanceof GeoRenderer) {
                GeoRenderer geoRenderer = (GeoRenderer)render;
                if (entity instanceof GeoAnimatable) {
                    GeoAnimatable animatable = (GeoAnimatable)entity;
                    if (data.texture == null) {
                        GeoModel geoModel = geoRenderer.getGeoModel();
                        data.texture = geoModel.getTextureResource(animatable);
                    }
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    isGeoModel = true;
                }
            }
            float partialTickTime = Minecraft.m_91087_().m_91296_();
            if (flyingGib.m_20096_() && flyingGib.timeToLive <= 20) {
                float offsetY = ((float)(20 - flyingGib.timeToLive) + partialTickTime) * -0.05f;
                if (isGeoModel) {
                    poseStack.m_252880_(0.0f, offsetY, 0.0f);
                } else {
                    poseStack.m_252880_(0.0f, -offsetY, 0.0f);
                }
            }
            poseStack.m_252880_(0.0f, -entity.m_6095_().m_20679_() / 2.0f, 0.0f);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            ResourceLocation texture = data.texture;
            RenderType rendertype = RenderType.m_110467_((ResourceLocation)texture);
            VertexConsumer vertexConsumer = buffer.m_6299_(rendertype);
            float prog = ((float)entity.f_20919_ + partialTicks - 1.0f) / 20.0f;
            float reverseProg = 1.0f - prog;
            float scale = 1.0f + prog / 2.0f;
            float reverseScale = 1.0f - prog / 4.0f;
            Rgba rgba = Rgba.DEFAULT;
            switch (flyingGib.getData().deathType) {
                case LASER: {
                    poseStack.m_85841_(scale, scale, scale);
                    if (isGeoModel) {
                        poseStack.m_85837_(0.0, (double)(-scale / 2.0f) / 16.0, 0.0);
                    } else {
                        poseStack.m_252880_(0.0f, -scale / 2.0f, 0.0f);
                    }
                    rgba = rgba.setAlpha(reverseProg);
                    break;
                }
                case FIRE: {
                    poseStack.m_85841_(reverseScale, 1.0f, reverseScale);
                    if (isGeoModel) {
                        poseStack.m_85837_(0.0, (double)(-reverseScale / 2.0f) / 16.0, 0.0);
                        break;
                    }
                    poseStack.m_252880_(0.0f, -reverseScale / 2.0f, 0.0f);
                    break;
                }
                case GORE: {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(prog * (float)flyingGib.rotationAxis.f_82479_));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(prog * (float)flyingGib.rotationAxis.f_82480_));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(prog * (float)flyingGib.rotationAxis.f_82481_));
                }
            }
            data.model.render((Entity)entity, flyingGib.getPartId(), poseStack, rendertype, buffer, vertexConsumer, packedLight, 0xFFFFFF, rgba);
            super.m_7392_((Entity)flyingGib, pEntityYaw, pPartialTick, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(FlyingGib entity) {
        EntityRenderer render = ClientProxy.getEntityRenderer((Entity)entity.getLocalEntity());
        return render.m_5478_((Entity)entity.getLocalEntity());
    }
}

