/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item;

import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.foundation.item.interfaces.IConfigConsumer;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AmmoItem
extends Item
implements IAmmo,
IConfigConsumer<ProjectileConfig> {
    private final IWeaponModifier[] modifiers;
    private ProjectileConfig projectile = new ProjectileConfig();

    public AmmoItem(Item.Properties properties, IWeaponModifier ... modifiers) {
        super(properties);
        this.modifiers = modifiers;
    }

    @Override
    public void setConfig(ConfigSupplier<ProjectileConfig> supplier) {
        this.projectile = supplier.config();
    }

    @Override
    public ProjectileConfig getAmmo() {
        return this.projectile;
    }

    @Override
    public IWeaponModifier[] getModifiers() {
        return this.modifiers;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        int maxDamage = this.getMaxDamage(stack);
        if (maxDamage > 0) {
            int ammoCount = maxDamage - this.getDamage(stack);
            tooltip.add((Component)Component.m_237110_((String)"info.ntgl.projectile", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + maxDamage}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

