/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item.attachment;

import com.nukateam.ntgl.client.tooltip.ItemsTooltipData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Attachment;
import com.nukateam.ntgl.common.data.config.attachment.AttachmentConfig;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AttachmentItem<T extends Attachment>
extends Item
implements IAttachment<T> {
    private final T attachmentData;
    private AttachmentConfig config;

    public AttachmentItem(AttachmentType type, T attachmentData, Item.Properties properties) {
        super(properties);
        this.config = AttachmentConfig.Builder.create().setType(type).build();
        this.attachmentData = attachmentData;
    }

    @Override
    public AttachmentConfig getAttachmentConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ConfigSupplier<AttachmentConfig> supplier) {
        this.config = supplier.config();
    }

    @Override
    public AttachmentType getType() {
        return this.config.getType();
    }

    @Override
    public T getProperties() {
        return this.attachmentData;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44975_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        List<Component> perks = ((Attachment)this.getProperties()).getPerks(stack);
        if (perks != null && !perks.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"perk.ntgl.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
            tooltip.addAll(perks);
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        List<ItemStack> weapons = ((Attachment)this.getProperties()).getWeapons(this);
        return Optional.of(new ItemsTooltipData(weapons));
    }
}

