/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.handlers;

import com.mojang.datafixers.util.Pair;
import com.nukateam.ntgl.client.util.handler.ClientEquipHandler;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ntgl", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEventHandler {
    public static final UUID SPEED_MODIFIER_ID = UUID.fromString("a1b2c3d4-5e6f-7890-1234-567890abcdef");
    public static final String MOVEMENT_SPEED = "custom_movement_speed";
    private static final Map<Pair<InteractionHand, Player>, Slot> lastSelectedSlots = new HashMap<Pair<InteractionHand, Player>, Slot>();
    public static final String ID = "WeaponId";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            ItemStack heldItem = player.m_21205_();
            AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
            if (movementSpeed != null) {
                movementSpeed.m_22120_(SPEED_MODIFIER_ID);
                if (heldItem.m_41720_() instanceof IWeapon) {
                    movementSpeed.m_22120_(SPEED_MODIFIER_ID);
                    movementSpeed.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, MOVEMENT_SPEED, (double)WeaponModifierHelper.getMovementSpeed(new WeaponData(heldItem, (LivingEntity)player)), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            PlayerEventHandler.tryEquip(event.player, InteractionHand.MAIN_HAND);
            PlayerEventHandler.tryEquip(event.player, InteractionHand.OFF_HAND);
        }
    }

    @SubscribeEvent
    public static void onChangeEquipment(LivingEquipmentChangeEvent event) {
        ItemStack oldItem = event.getFrom();
        ItemStack newItem = event.getTo();
        if (event.getSlot() == EquipmentSlot.MAINHAND || event.getSlot() == EquipmentSlot.OFFHAND) {
            InteractionHand hand = PlayerEventHandler.getHand(event.getSlot());
            Item item = newItem.m_41720_();
            if (item instanceof IThrowable) {
                IThrowable throwable = (IThrowable)item;
                if (newItem.m_41613_() < oldItem.m_41613_()) {
                    WeaponData data = new WeaponData(newItem, event.getEntity());
                    int equipTime = WeaponModifierHelper.getEquipTime(data);
                    EquipTracker.stopEquip(event.getEntity(), hand);
                    EquipTracker.startEquip(event.getEntity(), hand, equipTime);
                }
            } else {
                EquipTracker.stopEquip(event.getEntity(), hand);
            }
        }
    }

    private static void tryEquip(Player player, InteractionHand hand) {
        Pair key = new Pair((Object)hand, (Object)player);
        Slot lastSlot = lastSelectedSlots.getOrDefault(key, new Slot(ItemStack.f_41583_, 0, 0));
        ItemStack newItem = player.m_21120_(hand);
        if (newItem.m_41720_() != lastSlot.stack.m_41720_() || newItem.m_41613_() < lastSlot.stackSize() || player.m_150109_().f_35977_ != lastSlot.slotId) {
            if (newItem.m_41720_() instanceof IThrowable && newItem.m_41613_() < lastSlot.stackSize()) {
                WeaponData data = new WeaponData(newItem, (LivingEntity)player);
                int equipTime = WeaponModifierHelper.getEquipTime(data);
                ClientEquipHandler.get().setEquiping(hand, equipTime);
            }
            lastSelectedSlots.put((Pair<InteractionHand, Player>)key, new Slot(newItem, newItem.m_41613_(), player.m_150109_().f_35977_));
        }
    }

    @NotNull
    private static InteractionHand getHand(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private static String getId(ItemStack stack) {
        CompoundTag lastItemTag = stack.m_41784_();
        return lastItemTag.m_128425_(ID, 8) ? lastItemTag.m_128461_(ID) : UUID.randomUUID().toString();
    }

    record Slot(ItemStack stack, int stackSize, int slotId) {
    }
}

