/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.network.IMessage;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import com.nukateam.ntgl.common.network.enums.KeyAction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class C2SMessageGrenade
implements IMessage<C2SMessageGrenade> {
    private KeyAction action;
    private InteractionHand hand = InteractionHand.MAIN_HAND;
    WeaponMode weaponMode;

    public C2SMessageGrenade() {
    }

    public C2SMessageGrenade(KeyAction reload, InteractionHand hand, WeaponMode weaponMode) {
        this.action = reload;
        this.hand = hand;
        this.weaponMode = weaponMode;
    }

    @Override
    public void encode(C2SMessageGrenade message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.action);
        buffer.m_130068_((Enum)message.hand);
        buffer.m_130070_(message.weaponMode.toString());
    }

    @Override
    public C2SMessageGrenade decode(FriendlyByteBuf buffer) {
        return new C2SMessageGrenade((KeyAction)buffer.m_130066_(KeyAction.class), (InteractionHand)buffer.m_130066_(InteractionHand.class), WeaponMode.getType(buffer.m_130277_()));
    }

    @Override
    public void handle(C2SMessageGrenade message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            if (player != null && !player.m_5833_()) {
                ServerPlayHandler.handleGrenade(message, player);
            }
        });
        supplier.setPacketHandled(true);
    }

    public KeyAction getAction() {
        return this.action;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public WeaponMode getAttackMode() {
        return this.weaponMode;
    }
}

