/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.input;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class LongClickController {
    private final Map<Integer, Integer> keys = new HashMap<Integer, Integer>();
    private Integer lastKey;
    private int ticks = 0;
    private BiConsumer<Integer, Integer> repeatListener = (k, t) -> {};
    private BiConsumer<Integer, Integer> releaseListener = (k, t) -> {};

    public LongClickController() {
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
        MinecraftForge.EVENT_BUS.addListener(this::onMouseInput);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyInput);
    }

    public void setRepeatListener(BiConsumer<Integer, Integer> listener) {
        this.repeatListener = listener;
    }

    public void setReleaseListener(BiConsumer<Integer, Integer> listener) {
        this.releaseListener = listener;
    }

    private void onTick(TickEvent.ClientTickEvent event) {
        for (Integer key : this.keys.keySet()) {
            int ticks = this.keys.get(key) + 1;
            this.keys.put(key, ticks);
            this.repeatListener.accept(key, ticks);
        }
    }

    private void onMouseInput(InputEvent.MouseButton event) {
        this.onInput(event.getAction(), event.getButton());
    }

    private void onKeyInput(InputEvent.Key event) {
        this.onInput(event.getAction(), event.getKey());
    }

    private void onInput(int action, int key) {
        switch (action) {
            case 1: {
                this.onPress(key);
                break;
            }
            case 0: {
                this.onRelease(key);
            }
        }
    }

    private void onPress(int inputKey) {
        this.ticks = 0;
        this.keys.put(inputKey, 0);
    }

    private void onRelease(int inputKey) {
        this.keys.remove(inputKey);
        this.releaseListener.accept(inputKey, this.ticks);
    }
}

