/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.chassis_core.client.render.layers.HeldItemLayer;
import com.nukateam.chassis_core.client.render.utils.GeoUtils;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.DynamicGeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class ChassisRenderer<T extends WearableChassis>
extends DynamicGeoEntityRenderer<T> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    protected Collection<String> bonesToHide;
    private MultiBufferSource bufferSource;

    public ChassisRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager, model);
        this.addRenderLayer((GeoRenderLayer)new HeldItemLayer<WearableChassis>((GeoRenderer<WearableChassis>)this, this::getItemForBone));
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = ((WearableChassis)((Object)animatable)).getPassengerItem(EquipmentSlot.MAINHAND);
        this.offHandItem = ((WearableChassis)((Object)animatable)).getPassengerItem(EquipmentSlot.OFFHAND);
        this.bonesToHide = ((Chassis)((Object)animatable)).getBonesToHide();
    }

    public void defaultRender(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        this.bufferSource = bufferSource;
        if (this.isInvisible(animatable)) {
            return;
        }
        super.defaultRender(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        for (String name : ((Chassis)((Object)entity)).getMods()) {
            this.getGeoModel().getBone(name).ifPresent(bone -> bone.setHidden(true));
        }
        for (String name : ((Chassis)((Object)entity)).getVisibleMods()) {
            this.getGeoModel().getBone(name).ifPresent(bone -> bone.setHidden(false));
        }
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void defaultRenderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.m_7860_((Entity)((WearableChassis)this.animatable), 1.0f).m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)((WearableChassis)this.animatable).m_20182_().m_252839_()));
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        this.textureOverride = this.getTextureOverrideForBone(bone, (WearableChassis)this.animatable, partialTick);
        ResourceLocation texture = this.textureOverride == null ? this.m_5478_((Entity)((WearableChassis)this.animatable)) : this.textureOverride;
        RenderType renderTypeOverride = this.getRenderTypeOverrideForBone(bone, (Entity)((WearableChassis)this.animatable), texture, bufferSource, partialTick);
        if (texture != null && renderTypeOverride == null) {
            renderTypeOverride = this.getRenderType((GeoAnimatable)((WearableChassis)this.animatable), texture, bufferSource, partialTick);
        }
        if (renderTypeOverride != null) {
            buffer = bufferSource.m_6299_(renderTypeOverride);
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha)) {
            super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (renderTypeOverride != null) {
            buffer = bufferSource.m_6299_(this.getRenderType((GeoAnimatable)((WearableChassis)this.animatable), this.m_5478_((Entity)((WearableChassis)this.animatable)), bufferSource, partialTick));
        }
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        bone.setHidden(this.bonesToHide.contains(bone.getName()));
        if (Objects.equals(bone.getName(), "head_frame")) {
            bone.setHidden(true);
            bone.setChildrenHidden(false);
            this.renderHead(poseStack, animatable, bone, packedLight, packedOverlay);
        }
        this.defaultRenderRecursively(poseStack, animatable, bone, renderType, bufferSource, this.bufferSource.m_6299_(renderType), isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderChildBones(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!bone.isHidingChildren()) {
            ArrayList<GeoBone> bonesToRender = new ArrayList<GeoBone>(bone.getChildBones());
            Collection<GeoBone> equipmentBones = ((Chassis)((Object)animatable)).getAttachmentForBone(bone.getName());
            bonesToRender.addAll(equipmentBones);
            for (GeoBone childBone : bonesToRender) {
                this.renderRecursively(poseStack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, T animatable, float partialTick) {
        return GeoUtils.getTextureForBone(bone, animatable);
    }

    protected void renderNameTag(T entity, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity livingEntity = ((WearableChassis)((Object)entity)).m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            super.m_7649_(entity, player.m_7755_(), poseStack, buffer, packedLight);
        }
    }

    protected void renderHead(PoseStack poseStack, T animatable, GeoBone bone, int packedLight, int packedOverlay) {
        if (!animatable.m_20145_() && ((WearableChassis)((Object)animatable)).hasPassenger()) {
            LivingEntityRenderer humanoidRenderer;
            LivingEntity passenger = ((WearableChassis)((Object)animatable)).m_6688_();
            EntityRenderer entityRenderer = ChassisRenderer.getEntityRenderDispatcher().m_114382_((Entity)passenger);
            if (entityRenderer instanceof LivingEntityRenderer && (entityRenderer = (humanoidRenderer = (LivingEntityRenderer)entityRenderer).m_7200_()) instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityRenderer;
                poseStack.m_85836_();
                RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                ResourceLocation skin = humanoidRenderer.m_5478_((Entity)passenger);
                VertexConsumer head = this.bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)skin));
                VertexConsumer hat = this.bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)skin));
                ChassisRenderer.renderHumanoidPart(poseStack, bone, packedLight, packedOverlay, humanoidModel, head);
                ChassisRenderer.renderHumanoidPart(poseStack, bone, packedLight, packedOverlay, humanoidModel, hat);
                poseStack.m_85849_();
            }
        }
    }

    protected ItemStack getItemForBone(GeoBone bone, T animatable) {
        if (animatable == null || !((WearableChassis)((Object)animatable)).hasPassenger()) {
            return null;
        }
        return switch (bone.getName()) {
            case "left_hand" -> this.offHandItem;
            case "right_hand" -> this.mainHandItem;
            default -> null;
        };
    }

    protected boolean isInvisible(T animatable) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        CameraType pov = Minecraft.m_91087_().f_91066_.m_92176_();
        return animatable.m_20363_((Entity)clientPlayer) && pov == CameraType.FIRST_PERSON;
    }

    @NotNull
    private static EntityRenderDispatcher getEntityRenderDispatcher() {
        return Minecraft.m_91087_().m_91290_();
    }

    private static void renderHumanoidPart(PoseStack poseStack, GeoBone bone, int packedLight, int packedOverlay, HumanoidModel humanoidModel, VertexConsumer head) {
        humanoidModel.f_102808_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        humanoidModel.f_102808_.m_171327_(0.0f, 0.0f, 0.0f);
        humanoidModel.f_102808_.m_104306_(poseStack, head, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

