/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.resources;

import com.nukateam.chassis_core.client.render.utils.ResourceHelper;
import com.nukateam.chassis_core.common.data.json.EquipmentConfig;
import com.nukateam.chassis_core.common.data.json.ModelConfigBase;
import com.nukateam.chassis_core.modules.config.utils.JsonDeserializers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class ModResourceManager {
    private static final String CONFIG_DIR = "config/model/";
    private static final String EQUIPMENT_DIR = "config/model/equipment";
    private static final String FRAME_DIR = "config/model/chassis";
    private static final String ITEM_DIR = "config/model/item";
    private final Map<String, EquipmentConfig> equipmentConfig = new HashMap<String, EquipmentConfig>();

    private static boolean isEmptyArray(Object obj) {
        if (obj.getClass().isArray()) {
            return 0 == Array.getLength(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.equals("");
    }

    private static Map<ResourceLocation, Resource> getJsonResources(String path) {
        return Minecraft.m_91087_().m_91098_().m_214159_(path, fileName -> fileName.m_135815_().endsWith(".json"));
    }

    private static BufferedReader getBufferedReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    @Nullable
    public EquipmentConfig getEquipmentConfig(String itemId) {
        return this.equipmentConfig.get(itemId);
    }

    public void loadConfigs() {
        this.loadEquipment();
    }

    private void loadEquipment() {
        for (ResourceLocation file : ModResourceManager.getJsonResources(EQUIPMENT_DIR).keySet()) {
            EquipmentConfig config = this.getConfig(file, EquipmentConfig.class);
            if (config == null) continue;
            if (ModResourceManager.isNotEmpty(config.parent)) {
                EquipmentConfig parent = this.getConfig(new ResourceLocation(config.parent), EquipmentConfig.class);
                try {
                    Field[] fields;
                    for (Field field : fields = config.getClass().getFields()) {
                        String str;
                        boolean isEmptyString;
                        Object obj = field.get(config);
                        boolean bl = isEmptyString = obj instanceof String && (str = (String)obj).equals("");
                        if (obj != null && !isEmptyString && !ModResourceManager.isEmptyArray(obj)) continue;
                        field.set(config, parent.getClass().getField(field.getName()).get(parent));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            config.onFinishLoading();
            this.equipmentConfig.put(config.name, config);
        }
    }

    @Nullable
    private <T extends ModelConfigBase> T getConfig(ResourceLocation resourceLocation, Class<T> classOfT) {
        try {
            BufferedReader readIn = this.getBufferedReader(resourceLocation);
            ModelConfigBase settings = (ModelConfigBase)JsonDeserializers.GSON_INSTANCE.fromJson((Reader)readIn, classOfT);
            settings.name = ResourceHelper.getResourceName(resourceLocation);
            return (T)settings;
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedReader getBufferedReader(ResourceLocation resourceLocation) throws IOException {
        return ModResourceManager.getBufferedReader(((Resource)Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).get()).m_215507_());
    }
}

