/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.input;

import com.nukateam.chassis_core.common.events.CommonInputEvent;
import com.nukateam.chassis_core.common.input.InputKey;
import com.nukateam.chassis_core.common.input.KeyAction;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CommonInputHandler {
    public static void onKeyInput(InputKey key, KeyAction action, Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new CommonInputEvent(key, action, player));
        if (!PlayerUtils.isWearingChassis((Entity)player) || key == null) {
            return;
        }
        if ((action == KeyAction.PRESS || action == KeyAction.REPEAT) && key == InputKey.JUMP) {
            PlayerUtils.getEntityChassis((Entity)player).jump();
        }
        switch (action) {
            case PRESS: {
                CommonInputHandler.onPress(key, player);
                break;
            }
            case RELEASE: {
                CommonInputHandler.onRelease(key, player);
                break;
            }
            case DOUBLE_CLICK: {
                CommonInputHandler.onDoubleClick(key, player);
                break;
            }
            case LONG_PRESS: {
                CommonInputHandler.onLongPress(key, player);
            }
        }
    }

    public static void onPress(InputKey key, Player player) {
    }

    public static void onRelease(InputKey key, Player player) {
        if (!PlayerUtils.isWearingChassis((Entity)player)) {
            return;
        }
    }

    public static void onDoubleClick(InputKey key, Player player) {
        if (!PlayerUtils.isWearingChassis((Entity)player)) {
            return;
        }
    }

    public static void onLongPress(InputKey key, Player player) {
    }
}

