/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.packet;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.chassis_core.client.network.ClientPlayHandler;
import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.network.managers.NetworkEquipmentManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class S2CMessageUpdateEquipmentConfig
extends PlayMessage<S2CMessageUpdateEquipmentConfig> {
    private ImmutableMap<ResourceLocation, EquipmentConfig> registeredConfigs;

    public void encode(S2CMessageUpdateEquipmentConfig message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkEquipmentManager.get()));
        NetworkEquipmentManager.get().writeRegisteredConfig(buffer);
    }

    public S2CMessageUpdateEquipmentConfig decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateEquipmentConfig message = new S2CMessageUpdateEquipmentConfig();
        message.registeredConfigs = NetworkEquipmentManager.readRegisteredConfigs(buffer);
        return message;
    }

    public void handle(S2CMessageUpdateEquipmentConfig message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleUpdateEquipment(message));
        supplier.setHandled(true);
    }

    public ImmutableMap<ResourceLocation, EquipmentConfig> getRegisteredConfig() {
        return this.registeredConfigs;
    }
}

