/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.example.common.registery;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import java.util.Set;
import net.minecraft.util.Mth;

public class WeaponModifiers {
    public static final IWeaponModifier SILENCED = new IWeaponModifier(){

        @Override
        public boolean silencedFire(boolean value, WeaponData data) {
            return true;
        }

        @Override
        public double modifyFireSoundRadius(double radius, WeaponData data) {
            return radius * 0.25;
        }

        @Override
        public int modifyFireRate(int rate, WeaponData data) {
            return 1;
        }
    };
    public static final IWeaponModifier REDUCED_DAMAGE = new IWeaponModifier(){};
    public static final IWeaponModifier SLOW_ADS = new IWeaponModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.95f;
        }
    };
    public static final IWeaponModifier SLOWER_ADS = new IWeaponModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.9f;
        }
    };
    public static final IWeaponModifier EXTENDED_MAG = new IWeaponModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return (int)((double)maxAmmo * 1.5);
        }
    };
    public static final IWeaponModifier DRUM_MAG = new IWeaponModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return maxAmmo * 4;
        }
    };
    public static final IWeaponModifier BETTER_CONTROL = new IWeaponModifier(){

        @Override
        public float recoilModifier(WeaponData data) {
            return 0.3f;
        }

        @Override
        public float kickModifier(WeaponData data) {
            return 0.8f;
        }

        @Override
        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.75f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.95f;
        }
    };
    public static final IWeaponModifier STABILISED = new IWeaponModifier(){

        @Override
        public float recoilModifier(WeaponData data) {
            return 0.4f;
        }

        @Override
        public float kickModifier(WeaponData data) {
            return 0.3f;
        }

        @Override
        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.5f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.9f;
        }

        @Override
        public int modifyFireRate(int rate, WeaponData data) {
            return rate + 20;
        }
    };
    public static final IWeaponModifier SUPER_STABILISED = new IWeaponModifier(){

        @Override
        public float recoilModifier(WeaponData data) {
            return 0.1f;
        }

        @Override
        public float kickModifier(WeaponData data) {
            return 0.1f;
        }

        @Override
        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.25f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * 0.5;
        }

        @Override
        public int modifyFireRate(int rate, WeaponData data) {
            return Mth.m_14045_((int)((int)((double)rate * 1.25)), (int)(rate + 1), (int)Integer.MAX_VALUE);
        }
    };
    public static final IWeaponModifier LIGHT_RECOIL = new IWeaponModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return (int)((double)maxAmmo * 2.5);
        }

        @Override
        public int modifyProjectileAmount(int amount, WeaponData data) {
            return IWeaponModifier.super.modifyProjectileAmount(amount, data);
        }

        @Override
        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, WeaponData data) {
            return IWeaponModifier.super.modifyAmmoItems(item, data);
        }

        @Override
        public float recoilModifier(WeaponData data) {
            return 0.75f;
        }

        @Override
        public float kickModifier(WeaponData data) {
            return 0.75f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)1.2f;
        }

        @Override
        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.8f;
        }

        @Override
        public int modifyFireRate(int rate, WeaponData data) {
            return rate * 2;
        }
    };
    public static final IWeaponModifier REDUCED_RECOIL = new IWeaponModifier(){

        @Override
        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, WeaponData data) {
            return Set.of(FireMode.AUTO, FireMode.MULTI);
        }

        @Override
        public int modifyFireRate(int rate, WeaponData data) {
            return 15;
        }

        @Override
        public float recoilModifier(WeaponData data) {
            return 1.53f;
        }

        @Override
        public float kickModifier(WeaponData data) {
            return 0.5f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.95f;
        }

        @Override
        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.5f;
        }
    };
}

