/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.network.KeyAction;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageGrenade;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ClientThrowHandler {
    private static final Map<InteractionHand, Tracker> TRACKER_MAP = new HashMap<InteractionHand, Tracker>();

    @SubscribeEvent
    public static void onPostClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END && minecraft.f_91074_ != null) {
            if (!minecraft.f_91066_.f_92096_.m_90857_()) {
                ClientThrowHandler.removeTracker(InteractionHand.MAIN_HAND, WeaponMode.PRIMARY);
                ClientThrowHandler.removeTracker(InteractionHand.OFF_HAND, WeaponMode.PRIMARY);
            }
            if (!minecraft.f_91066_.f_92095_.m_90857_()) {
                ClientThrowHandler.removeTracker(InteractionHand.MAIN_HAND, WeaponMode.SECONDARY);
                ClientThrowHandler.removeTracker(InteractionHand.OFF_HAND, WeaponMode.SECONDARY);
            }
            if (!NtglKeyBinds.KEY_ADD_ATTACK.m_90857_()) {
                ClientThrowHandler.removeTracker(InteractionHand.MAIN_HAND, WeaponMode.ADDITIONAL);
                ClientThrowHandler.removeTracker(InteractionHand.OFF_HAND, WeaponMode.ADDITIONAL);
            }
            if (!NtglKeyBinds.KEY_ALT_ATTACK.m_90857_()) {
                ClientThrowHandler.removeTracker(InteractionHand.MAIN_HAND, WeaponMode.ALTERNATIVE);
                ClientThrowHandler.removeTracker(InteractionHand.OFF_HAND, WeaponMode.ALTERNATIVE);
            }
        }
    }

    private static boolean isThrowMode(WeaponData weaponData) {
        return WeaponModifierHelper.getWeaponAction(weaponData) == WeaponAction.THROW;
    }

    public static void handleInput(WeaponData weaponData, InteractionHand hand, KeyMapping key) {
        if (!ClientThrowHandler.isThrowMode(weaponData)) {
            return;
        }
        ClientThrowHandler.addTracker(weaponData, hand);
    }

    public static void addTracker(WeaponData weaponData, InteractionHand hand) {
        if (ClientThrowHandler.isThrowable(weaponData) && !TRACKER_MAP.containsKey(hand)) {
            TRACKER_MAP.put(hand, new Tracker(weaponData, hand));
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGrenade(KeyAction.HOLD, hand, weaponData.weaponMode));
        }
    }

    private static void removeTracker(InteractionHand hand, WeaponMode mode) {
        if (TRACKER_MAP.containsKey(hand) && ClientThrowHandler.TRACKER_MAP.get((Object)hand).data.weaponMode == mode) {
            WeaponMode action = ClientThrowHandler.TRACKER_MAP.get((Object)hand).data.weaponMode;
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGrenade(KeyAction.RELEASE, hand, action));
            TRACKER_MAP.remove(hand);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack offhandItem;
        WeaponData gunData;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem = player.m_21205_();
            WeaponData gunData2 = new WeaponData(heldItem, (LivingEntity)player).setWeaponMode(WeaponMode.PRIMARY);
            if (ClientThrowHandler.isThrowable(gunData2)) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        } else if (event.isUseItem() && ClientThrowHandler.isThrowable(gunData = new WeaponData(offhandItem = player.m_21206_(), (LivingEntity)player).setWeaponMode(WeaponMode.PRIMARY)) && WeaponModifierHelper.canUseOffhandWeapon((LivingEntity)player)) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    private static boolean isThrowable(WeaponData weaponData) {
        return weaponData.weapon != null && weaponData.weapon.m_41720_() instanceof IThrowable && WeaponModifierHelper.isThrowable(weaponData);
    }

    private static class Tracker {
        private final WeaponData data;
        private final InteractionHand arm;
        private final ItemStack stack;
        private final LivingEntity entity;

        private Tracker(WeaponData data, InteractionHand arm) {
            this.data = data;
            this.arm = arm;
            this.entity = data.wielder;
            this.stack = this.entity.m_21120_(arm);
        }

        private void explode() {
            this.stop();
        }

        private void stop() {
            TRACKER_MAP.remove(this.arm);
        }

        private boolean isSameWeapon() {
            return !this.stack.m_41619_() && this.entity.m_21120_(this.arm) == this.stack;
        }
    }
}

