/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.attachment.impl;

import com.nukateam.example.common.registery.ExampleWeapons;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.WeaponHelper;
import com.nukateam.ntgl.common.data.config.weapon.Modules;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class Attachment {
    protected IWeaponModifier[] modifiers;
    private List<Component> perks = null;
    private List<ItemStack> weapons = null;

    public Attachment(IWeaponModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IWeaponModifier[] getModifiers() {
        return this.modifiers;
    }

    void setPerks(List<Component> perks) {
        if (this.perks == null) {
            this.perks = perks;
        }
    }

    void setWeapons(List<ItemStack> perks) {
        if (this.weapons == null) {
            this.weapons = perks;
        }
    }

    public List<ItemStack> getWeapons(Item attachment) {
        if (this.weapons != null && !this.weapons.isEmpty()) {
            return this.weapons;
        }
        this.weapons = new ArrayList<ItemStack>();
        ArrayList<Item> weaponItems = WeaponHelper.getWeaponItems();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)attachment);
        for (Item item : weaponItems) {
            IWeapon weapon = (IWeapon)item;
            if (!Attachment.hasAttachment(weapon, id)) continue;
            this.weapons.add(new ItemStack((ItemLike)item));
        }
        return this.weapons;
    }

    private static boolean hasAttachment(IWeapon weapon, ResourceLocation id) {
        Collection<ArrayList<Modules.Attachment>> list = ((WeaponConfig)weapon.getConfig()).getModules().getAttachments().values();
        for (ArrayList<Modules.Attachment> configs : list) {
            for (Modules.Attachment config : configs) {
                if (config.getItemId() == null || !config.getItemId().equals((Object)id)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Component> getPerks(ItemStack stack) {
        if (this.perks != null && !this.perks.isEmpty()) {
            return this.perks;
        }
        WeaponData data = new WeaponData(new ItemStack((ItemLike)ExampleWeapons.CLASSIC10MM.get()), null);
        data.attachment = stack;
        ArrayList<Component> perks = new ArrayList<Component>();
        this.getNumericPerk(perks, "perk.ntgl.max_ammo", true, (modifier, val) -> Float.valueOf(modifier.modifyMaxAmmo((int)val.floatValue(), data)));
        this.getNumericPerk(perks, "perk.ntgl.projectile_amount", (modifier, val) -> Float.valueOf(modifier.modifyProjectileAmount((int)val.floatValue(), data)));
        this.fireSoundVolume(data, perks);
        this.silenced(data, perks);
        this.soundRadius(data, perks);
        this.damage(data, perks);
        this.meleeDamage(data, perks);
        this.meleeDistance(data, perks);
        this.spread(data, perks);
        this.life(data, perks);
        this.recoil(data, perks);
        this.adsSpeed(data, perks);
        this.rate(data, perks);
        this.fireModes(data, perks);
        this.setPerks(perks);
        return this.perks;
    }

    private void fireSoundVolume(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.fire_volume", (modifier, val) -> Float.valueOf(modifier.modifyFireSoundVolume(val.floatValue(), data)));
    }

    private void silenced(WeaponData data, ArrayList<Component> positivePerks) {
        for (IWeaponModifier modifier : this.modifiers) {
            if (!modifier.silencedFire(false, data)) continue;
            Attachment.addPerk(positivePerks, true, "perk.ntgl.silenced", new Object[0]);
            break;
        }
    }

    private void soundRadius(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.sound_radius", (modifier, val) -> Float.valueOf((float)modifier.modifyFireSoundRadius(val.floatValue(), data)));
    }

    private void fireModes(WeaponData data, ArrayList<Component> positivePerks) {
        HashSet<FireMode> inputFireModes = new HashSet<FireMode>();
        Set<Object> outputFireModes = new HashSet();
        for (IWeaponModifier modifier : this.modifiers) {
            outputFireModes = modifier.modifyFireModes(inputFireModes, data);
        }
        if (!outputFireModes.equals(inputFireModes)) {
            MutableComponent modes = Component.m_237119_();
            for (FireMode fireMode : outputFireModes) {
                modes.m_7220_(fireMode.getDisplayName()).m_130946_("; ");
            }
            Attachment.addPerk(positivePerks, "perk.ntgl.fire_modes", (Component)modes);
        }
    }

    private void rate(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.rate", (modifier, val) -> Float.valueOf(modifier.modifyFireRate((int)val.floatValue(), data)));
    }

    private void adsSpeed(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.ads_speed", true, (modifier, val) -> Float.valueOf((float)modifier.modifyAimDownSightSpeed(val.floatValue(), data)));
    }

    private void recoil(WeaponData data, ArrayList<Component> positivePerks) {
        float inputRecoil;
        float outputRecoil = inputRecoil = 1.0f;
        for (IWeaponModifier modifier : this.modifiers) {
            outputRecoil *= modifier.recoilModifier(data);
        }
        if (outputRecoil != inputRecoil) {
            String percent = Attachment.getPercent(outputRecoil / inputRecoil);
            Attachment.addPerk(positivePerks, outputRecoil < inputRecoil, "perk.ntgl.recoil", percent);
        }
    }

    private void life(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.projectile_life", true, (modifier, val) -> Float.valueOf(modifier.modifyProjectileLife((int)val.floatValue(), data)));
    }

    private void spread(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.projectile_spread", (modifier, val) -> Float.valueOf(modifier.modifyProjectileSpread(val.floatValue(), data)));
    }

    private void damage(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.modified_damage", true, (modifier, val) -> Float.valueOf(modifier.modifyProjectileDamage(val.floatValue(), ExampleWeapons.CLASSIC10MM.getId(), data)));
    }

    private void meleeDamage(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.melee_damage", true, (modifier, val) -> Float.valueOf(modifier.modifyMeleeDamage(val.floatValue(), data)));
    }

    private void meleeDistance(WeaponData data, ArrayList<Component> positivePerks) {
        this.getNumericPerk(positivePerks, "perk.ntgl.melee_distance", (modifier, val) -> Float.valueOf(modifier.modifyMeleeDistance(val.floatValue(), data)));
    }

    private void getNumericPerk(ArrayList<Component> positivePerks, String name, BiFunction<IWeaponModifier, Float, Float> function) {
        this.getNumericPerk(positivePerks, name, false, function);
    }

    private void getNumericPerk(ArrayList<Component> positivePerks, String name, boolean invert, BiFunction<IWeaponModifier, Float, Float> function) {
        float input1 = 1.0f;
        float input2 = 2.0f;
        float output1 = input1;
        float output2 = input2;
        for (IWeaponModifier modifier : this.modifiers) {
            output1 = function.apply(modifier, Float.valueOf(output1)).floatValue();
            output2 = function.apply(modifier, Float.valueOf(output2)).floatValue();
        }
        if (output1 != input1) {
            float outputRatio1 = output1 / input1;
            float outputRatio2 = output2 / input2;
            String value = "";
            if (outputRatio1 == outputRatio2) {
                value = Attachment.getPercent(outputRatio1);
            } else {
                float num = 0.0f;
                for (IWeaponModifier modifier : this.modifiers) {
                    num = function.apply(modifier, Float.valueOf(num)).floatValue();
                }
                value = Attachment.getValue(num, output1 != output2);
            }
            boolean positive = invert ? output1 > input1 : output1 < input1;
            Attachment.addPerk(positivePerks, positive, name, value);
        }
    }

    private static String getPercent(double value) {
        double percent = Math.abs((1.0 - value) * 100.0);
        String formated = ItemStack.f_41584_.format(percent);
        String sign = value >= 1.0 ? "+" : "-";
        return sign + formated + "%";
    }

    private static String getValue(double value, boolean signed) {
        String formated = ItemStack.f_41584_.format(value);
        String sign = value > 0.0 && signed ? "+" : "";
        return sign + formated;
    }

    private static void addPerk(List<Component> components, boolean positive, String id, Object ... params) {
        Object object;
        ChatFormatting style;
        String icon = positive ? "perk.ntgl.entry.positive" : "perk.ntgl.entry.negative";
        ChatFormatting chatFormatting = style = positive ? ChatFormatting.DARK_AQUA : ChatFormatting.GOLD;
        if (params.length == 1 && (object = params[0]) instanceof String) {
            String value = (String)object;
            components.add((Component)Component.m_237110_((String)icon, (Object[])new Object[]{Component.m_237110_((String)id, (Object[])new Object[]{ChatFormatting.WHITE + value}).m_130940_(ChatFormatting.GRAY)}).m_130940_(style));
        } else {
            components.add((Component)Component.m_237110_((String)icon, (Object[])new Object[]{Component.m_237110_((String)id, (Object[])params).m_130940_(ChatFormatting.GRAY)}).m_130940_(style));
        }
    }

    private static void addPerk(List<Component> components, String id, Component param) {
        components.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)id).m_130940_(ChatFormatting.GRAY)).m_7220_(param).m_130940_(ChatFormatting.WHITE));
    }
}

