/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.AmmoData;
import com.nukateam.ntgl.common.data.config.weapon.Fuel;
import com.nukateam.ntgl.common.data.config.weapon.General;
import com.nukateam.ntgl.common.data.config.weapon.Melee;
import com.nukateam.ntgl.common.data.config.weapon.Modules;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.weapon.Sounds;
import com.nukateam.ntgl.common.data.config.weapon.ThrowableConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponSettings;
import com.nukateam.ntgl.common.data.config.weapon.Zoom;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugButton;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String GENERAL = "General";
    public static final String MELEE = "Melee";
    public static final String THROWABLE = "Throwable";
    public static final String SOUNDS = "Sounds";
    public static final String DISPLAY = "Display";
    public static final String MODULES = "Modules";
    public static final String TEXTURES = "Textures";
    public static final String ANIMATIONS = "Animations";
    public static final String AMMO_DATA = "AmmoData";
    public static final String SECONDARY_AMMO = "SecondaryAmmo";
    public static final String MODES = "Modes";
    protected General general = WeaponConfig.getWeapon();
    protected Melee melee = new Melee();
    protected ThrowableConfig throwable = new ThrowableConfig();
    protected HashMap<WeaponMode, WeaponSettings> modes = new HashMap(Map.of());
    protected Modules modules = new Modules();
    @Optional
    protected Zoom zoom = new Zoom();
    protected HashMap<AnimationType, ResourceLocation> animations = new HashMap();
    protected LinkedHashMap<ResourceLocation, AmmoData> ammoData = new LinkedHashMap();
    protected LinkedHashMap<ResourceLocation, Fuel> fuel = new LinkedHashMap();
    protected HashMap<String, ResourceLocation> sounds = new HashMap();
    protected HashMap<String, ResourceLocation> textures = new HashMap();

    private static General getWeapon() {
        General gun = new General();
        gun.action = WeaponAction.SHOT;
        return gun;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = WeaponStateHelper.getScopeStack(heldItem);
            Item patt3766$temp = scope.m_41720_();
            if (patt3766$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt3766$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(GENERAL, (Tag)this.general.serializeNBT());
        tag.m_128365_(MELEE, (Tag)this.melee.serializeNBT());
        tag.m_128365_(THROWABLE, (Tag)this.throwable.serializeNBT());
        tag.m_128365_(SOUNDS, (Tag)NbtUtils.serializeStringMap(this.sounds));
        tag.m_128365_(MODULES, (Tag)this.modules.serializeNBT());
        tag.m_128365_(TEXTURES, (Tag)NbtUtils.serializeStringMap(this.textures));
        tag.m_128365_(ANIMATIONS, (Tag)NbtUtils.serializeStringMap(this.animations));
        tag.m_128365_(AMMO_DATA, (Tag)NbtUtils.serializeMap(this.ammoData));
        tag.m_128365_(SECONDARY_AMMO, (Tag)NbtUtils.serializeMap(this.fuel));
        tag.m_128365_(MODES, (Tag)NbtUtils.serializeMap(this.modes));
        if (this.zoom != null) {
            tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(GENERAL, 10)) {
            this.general.deserializeNBT(tag.m_128469_(GENERAL));
        }
        if (tag.m_128425_(MELEE, 10)) {
            this.melee.deserializeNBT(tag.m_128469_(MELEE));
        }
        if (tag.m_128425_(THROWABLE, 10)) {
            this.throwable.deserializeNBT(tag.m_128469_(THROWABLE));
        }
        if (tag.m_128425_(SOUNDS, 10)) {
            this.sounds = this.deserializeSounds(tag.m_128469_(SOUNDS));
        }
        if (tag.m_128425_(MODULES, 10)) {
            this.modules.deserializeNBT(tag.m_128469_(MODULES));
        }
        if (tag.m_128425_(TEXTURES, 10)) {
            this.textures = NbtUtils.deserializeRLMap(tag.m_128469_(TEXTURES));
        }
        if (tag.m_128425_(ANIMATIONS, 10)) {
            this.animations = NbtUtils.deserializeMap(tag.m_128469_(ANIMATIONS), AnimationType::getType, (nbt, key) -> ResourceLocation.m_135820_((String)nbt.m_128461_(key)));
        }
        if (tag.m_128425_(AMMO_DATA, 10)) {
            this.ammoData = NbtUtils.deserializeLinkedMap(tag.m_128469_(AMMO_DATA), AmmoData::create);
        }
        if (tag.m_128425_(SECONDARY_AMMO, 10)) {
            this.fuel = NbtUtils.deserializeLinkedMap(tag.m_128469_(SECONDARY_AMMO), Fuel::create);
        }
        if (tag.m_128425_(MODES, 10)) {
            this.modes = NbtUtils.deserializeMap(tag.m_128469_(MODES), WeaponMode::getType, (nbt, key) -> WeaponSettings.create(nbt.m_128469_(key)));
        }
        if (tag.m_128425_("Zoom", 10)) {
            this.zoom = Zoom.create(tag.m_128469_("Zoom"));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("melee", (JsonElement)this.melee.toJsonObject());
        object.add("throwable", (JsonElement)this.throwable.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "ammoData", gson.toJsonTree(this.ammoData).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", gson.toJsonTree(this.sounds).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modes", gson.toJsonTree(this.modes).getAsJsonObject());
        if (this.zoom != null) {
            object.add("zoom", (JsonElement)this.zoom.toJsonObject());
        }
        return object;
    }

    public WeaponConfig copy() {
        WeaponConfig gun = new WeaponConfig();
        gun.general = this.general.copy();
        gun.melee = this.melee.copy();
        gun.throwable = this.throwable.copy();
        gun.sounds = (HashMap)this.sounds.clone();
        gun.textures = (HashMap)this.textures.clone();
        gun.animations = (HashMap)this.animations.clone();
        gun.ammoData = (LinkedHashMap)this.ammoData.clone();
        gun.fuel = (LinkedHashMap)this.fuel.clone();
        gun.modules = this.modules.copy();
        gun.zoom = this.zoom.copy();
        return gun;
    }

    public static WeaponConfig create(ResourceLocation id, CompoundTag tag) {
        WeaponConfig gun = new WeaponConfig();
        gun.deserializeNBT(tag);
        return gun;
    }

    public void onCreated(String id) {
    }

    public General getGeneral() {
        return this.general;
    }

    public Melee getMelee() {
        return this.melee;
    }

    public ThrowableConfig getThrowable() {
        return this.throwable;
    }

    public Sounds getSounds() {
        return new Sounds(this);
    }

    public HashMap<String, ResourceLocation> getSoundsMap() {
        return this.sounds;
    }

    public Modules getModules() {
        return this.modules;
    }

    public Map<String, ResourceLocation> getTextures() {
        return this.textures;
    }

    public HashMap<AnimationType, ResourceLocation> getAnimations() {
        return this.animations;
    }

    public ResourceLocation getAnimation(AnimationType type) {
        return this.animations.get(type);
    }

    public boolean canAttachType(@Nullable AttachmentType type) {
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> attachments = this.getModules().getAttachments();
        if (attachments == null) {
            return false;
        }
        return attachments.containsKey(type);
    }

    public ArrayList<Modules.Attachment> getAttachmentConfigs(ArrayList<ItemStack> itemStacks) {
        ArrayList<Modules.Attachment> result = new ArrayList<Modules.Attachment>();
        for (ItemStack stack : itemStacks) {
            Item item = stack.m_41720_();
            Modules.Attachment attachment = this.findAttachment(item);
            if (attachment == null) continue;
            result.add(attachment);
        }
        return result;
    }

    public Modules.Attachment findAttachment(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (item instanceof IAttachment) {
            IAttachment attachmentItem = (IAttachment)item;
            AttachmentType attachmentType = attachmentItem.getType();
            if (!this.getModules().getAttachments().containsKey(attachmentType)) {
                return new Modules.Attachment();
            }
            ArrayList<Modules.Attachment> attachments = this.getModules().getAttachments().get(attachmentType);
            for (Modules.Attachment attachment : attachments) {
                if (attachment.getItemId() == null || !attachment.getItemId().equals((Object)itemId)) continue;
                return attachment;
            }
        }
        return new Modules.Attachment();
    }

    public void playCockSound(LivingEntity player) {
        if (!player.m_9236_().f_46443_) {
            ResourceLocation cockSound = this.getSounds().getCock();
            if (!player.m_6084_()) {
                return;
            }
            if (cockSound == null) {
                cockSound = ((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get()).m_11660_();
            }
            Double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            S2CMessageGunSound messageSound = new S2CMessageGunSound(cockSound, SoundSource.PLAYERS, player, 1.0f, 1.0f, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)(player.m_20186_() + 1.0), (double)player.m_20189_(), (double)radius), (IMessage)messageSound);
        }
    }

    public AmmoData getAmmoData(ResourceLocation ammo) {
        return this.ammoData.getOrDefault(ammo, new AmmoData());
    }

    public Fuel getFuelData(ResourceLocation ammo) {
        return this.fuel.getOrDefault(ammo, new Fuel());
    }

    public boolean hasAmmo(ResourceLocation ammo) {
        return this.ammoData.containsKey(ammo);
    }

    public ProjectileConfig getProjectileConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getProjectile();
    }

    public AmmoConfig getAmmoConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getAmmo();
    }

    public Fuel getFuelConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo);
    }

    public AmmoConfig getFuelAmmoConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo).getAmmo();
    }

    public General getGeneral(WeaponMode mode) {
        if (mode == WeaponMode.PRIMARY) {
            return this.general;
        }
        return this.modes.getOrDefault(mode, new WeaponSettings()).getGeneral();
    }

    public Melee getMelee(WeaponMode mode) {
        if (mode == WeaponMode.PRIMARY) {
            return this.melee;
        }
        return this.modes.getOrDefault(mode, new WeaponSettings()).getMelee();
    }

    public ThrowableConfig getThrowable(WeaponMode mode) {
        if (mode == WeaponMode.PRIMARY) {
            return this.throwable;
        }
        return this.modes.getOrDefault(mode, new WeaponSettings()).getThrowable();
    }

    public Zoom getZoom(WeaponMode mode) {
        if (mode == WeaponMode.PRIMARY) {
            return this.zoom;
        }
        return this.modes.getOrDefault(mode, new WeaponSettings()).getZoom();
    }

    public HashMap<WeaponMode, WeaponSettings> getModes() {
        return this.modes;
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : ResourceLocation.m_135820_((String)sound);
    }

    public static class Builder {
        private final WeaponConfig weaponConfig;

        private Builder() {
            this.weaponConfig = new WeaponConfig();
        }

        private Builder(WeaponConfig weaponConfig) {
            this.weaponConfig = weaponConfig.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(WeaponConfig weaponConfig) {
            return new Builder(weaponConfig);
        }

        public WeaponConfig build() {
            return this.weaponConfig.copy();
        }

        public Builder addAmmo(AmmoHolder id) {
            this.weaponConfig.general.ammo.add(id);
            return this;
        }

        public Builder setFireRate(int rate) {
            this.weaponConfig.general.rate = rate;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.weaponConfig.general.gripType = gripType;
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.weaponConfig.general.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.weaponConfig.general.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setReloadTime(int reloadTime) {
            this.weaponConfig.general.reloadTime = reloadTime;
            return this;
        }

        public Builder setLoadingType(LoadingType loadingType) {
            this.weaponConfig.general.loadingType = loadingType;
            return this;
        }

        public Builder setCategory(String category) {
            this.weaponConfig.general.category = category;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.weaponConfig.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.weaponConfig.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.weaponConfig.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.weaponConfig.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.weaponConfig.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.weaponConfig.general.spread = spread;
            return this;
        }
    }
}

