/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private final int maxWeight;

    public AmmoBoxItem(Item.Properties pProperties, int maxWeight) {
        super(pProperties);
        this.maxWeight = maxWeight;
    }

    public float getFullnessDisplay(ItemStack stack) {
        return (float)this.getContentWeight(stack) / 64.0f;
    }

    public boolean m_142207_(ItemStack stack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (stack.m_41613_() == 1 && pAction == ClickAction.SECONDARY) {
            ItemStack itemstack = pSlot.m_7993_();
            if (itemstack.m_41619_()) {
                this.playRemoveOneSound((Entity)pPlayer);
                this.removeOne(stack).ifPresent(p_150740_ -> this.add(stack, pSlot.m_150659_(p_150740_)));
            } else if (itemstack.m_41720_().m_142095_()) {
                int i = (this.maxWeight - this.getContentWeight(stack)) / this.getWeight(itemstack);
                int j = this.add(stack, pSlot.m_150647_(itemstack.m_41613_(), i, pPlayer));
                if (j > 0) {
                    this.playInsertSound((Entity)pPlayer);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            if (pOther.m_41619_()) {
                this.removeOne(stack).ifPresent(p_186347_ -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(p_186347_);
                });
            } else {
                int i = this.add(stack, pOther);
                if (i > 0) {
                    this.playInsertSound((Entity)pPlayer);
                    pOther.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (this.dropContents(itemstack, pPlayer)) {
            this.playDropContentsSound((Entity)pPlayer);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getContentWeight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * this.getContentWeight(stack) / this.maxWeight, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        NonNullList list = NonNullList.m_122779_();
        Stream<ItemStack> stream = AmmoBoxItem.getContents(stack);
        Objects.requireNonNull(list);
        stream.forEach(arg_0 -> list.add(arg_0));
        return Optional.of(new BundleTooltip(list, this.getContentWeight(stack)));
    }

    public void m_7373_(@NotNull ItemStack stack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{this.getContentWeight(stack), 64}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(@NotNull ItemEntity pItemEntity) {
        ItemUtils.m_150952_((ItemEntity)pItemEntity, AmmoBoxItem.getContents(pItemEntity.m_32055_()));
    }

    public int getAmmoCount(ItemStack ammoBox, Item item) {
        int result = 0;
        for (ItemStack ammo : AmmoBoxItem.getContents(ammoBox).toList()) {
            if (ammo.m_41720_() != item) continue;
            result += ammo.m_41613_();
        }
        return result;
    }

    private int add(ItemStack pBundleStack, ItemStack insertedStack) {
        if (!insertedStack.m_41619_() && insertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = pBundleStack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = this.getContentWeight(pBundleStack);
            int j = this.getWeight(insertedStack);
            int k = Math.min(insertedStack.m_41613_(), (64 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = AmmoBoxItem.getMatchingItem(insertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                itemstack.m_41769_(k);
                itemstack.m_41739_(compoundtag1);
                listtag.remove((Object)compoundtag1);
                listtag.add(0, (Tag)compoundtag1);
            } else {
                ItemStack itemstack1 = insertedStack.m_255036_(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag pList) {
        Optional<CompoundTag> var10000;
        if (stack.m_150930_(Items.f_151058_)) {
            var10000 = Optional.empty();
        } else {
            Stream<Tag> var2 = pList.stream();
            Objects.requireNonNull(CompoundTag.class);
            var2 = var2.filter(CompoundTag.class::isInstance);
            Objects.requireNonNull(CompoundTag.class);
            var10000 = var2.map(CompoundTag.class::cast).filter(p_186350_ -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)p_186350_), (ItemStack)stack)).findFirst();
        }
        return var10000;
    }

    private int getWeight(ItemStack stack) {
        return this.maxWeight / stack.m_41741_();
    }

    private int getContentWeight(ItemStack stack) {
        return AmmoBoxItem.getContents(stack).mapToInt(p_186356_ -> this.getWeight((ItemStack)p_186356_) * p_186356_.m_41613_()).sum();
    }

    private Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private boolean dropContents(ItemStack stack, Player pPlayer) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (pPlayer instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                pPlayer.m_36176_(itemstack, true);
            }
        }
        stack.m_41749_(TAG_ITEMS);
        return true;
    }

    public static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundtag.m_128437_(TAG_ITEMS, 10);
        Stream tagStream = listTag.stream();
        Objects.requireNonNull(CompoundTag.class);
        return tagStream.map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

