/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nukateam.ntgl.common.foundation.init.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class TrailData
implements ParticleOptions {
    public static final Codec<TrailData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("enchanted").forGetter(data -> data.enchanted)).apply((Applicative)builder, TrailData::new));
    public static final ParticleOptions.Deserializer<TrailData> DESERIALIZER = new ParticleOptions.Deserializer<TrailData>(){

        public TrailData fromCommand(ParticleType<TrailData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new TrailData(reader.readBoolean());
        }

        public TrailData fromNetwork(ParticleType<TrailData> particleType, FriendlyByteBuf buffer) {
            return new TrailData(buffer.readBoolean());
        }
    };
    private boolean enchanted;

    public TrailData(boolean enchanted) {
        this.enchanted = enchanted;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.TRAIL.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.enchanted);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.enchanted;
    }
}

