/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class C2SMessageShoot
extends PlayMessage<C2SMessageShoot> {
    private int shooterId;
    private float rotationYaw;
    private float rotationPitch;
    private float randP;
    private float randY;
    private InteractionHand hand;
    WeaponMode action;

    public C2SMessageShoot() {
    }

    public C2SMessageShoot(int shooterId, float yaw, float pitch, float randP, float randY, InteractionHand hand, WeaponMode action) {
        this.shooterId = shooterId;
        this.rotationPitch = pitch;
        this.rotationYaw = yaw;
        this.randP = randP;
        this.randY = randY;
        this.hand = hand;
        this.action = action;
    }

    public void encode(C2SMessageShoot messageShoot, FriendlyByteBuf buffer) {
        buffer.writeInt(messageShoot.shooterId);
        buffer.writeFloat(messageShoot.rotationYaw);
        buffer.writeFloat(messageShoot.rotationPitch);
        buffer.writeFloat(messageShoot.randP);
        buffer.writeFloat(messageShoot.randY);
        buffer.m_130068_((Enum)messageShoot.hand);
        buffer.m_130070_(messageShoot.action.toString());
    }

    public C2SMessageShoot decode(FriendlyByteBuf buffer) {
        return new C2SMessageShoot(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), (InteractionHand)buffer.m_130066_(InteractionHand.class), WeaponMode.getType(buffer.m_130277_()));
    }

    public void handle(C2SMessageShoot messageShoot, MessageContext supplier) {
        supplier.execute(() -> {
            Entity shooter;
            ServerPlayer player = supplier.getPlayer();
            if (player != null && (shooter = player.m_9236_().m_6815_(messageShoot.shooterId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)shooter;
                ServerPlayHandler.handleShoot(messageShoot, livingEntity);
            }
        });
        supplier.setHandled(true);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public WeaponMode getMode() {
        return this.action;
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }
}

