/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.util.helpers.compatibility.SubtleEffectsHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EffectHelper {
    private static final RandomSource random = RandomSource.m_216327_();

    public static void doSplashEffect(Vec3 pos, float size, float speed, boolean isInLava) {
        if (Ntgl.subtleEffectsLoaded && SubtleEffectsHelper.doSplashEffect(pos, size, speed, isInLava)) {
            return;
        }
        if (!isInLava) {
            EffectHelper.doWaterSplashEffect(pos, size, speed);
        }
    }

    public static void doExplosionSplash(Level level, float radius, Vec3 position) {
        if (Ntgl.subtleEffectsLoaded) {
            SubtleEffectsHelper.doExplosionSplash(level, radius, position);
        }
    }

    private static void doWaterSplashEffect(Vec3 pos, float size, float speed) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Vec3 velocity = pos.m_82542_((double)speed, (double)speed, (double)speed);
        EffectHelper.playSplashSound(pos);
        float waterLevelY = (float)Mth.m_14107_((double)pos.f_82480_) + 1.0f;
        int i = 0;
        while ((float)i < 1.0f + size * 20.0f) {
            EffectHelper.addBubbleParticle(pos, size, level, waterLevelY, velocity);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + size * 20.0f) {
            EffectHelper.addSplashParticle(pos, size, level, waterLevelY, velocity);
            ++j;
        }
    }

    private static void addSplashParticle(Vec3 pos, float size, ClientLevel level, float waterLevelY, Vec3 velocity) {
        double offsetX = (random.m_188500_() * 2.0 - 1.0) * (double)size;
        double offsetZ = (random.m_188500_() * 2.0 - 1.0) * (double)size;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, pos.f_82479_ + offsetX, (double)waterLevelY, pos.f_82481_ + offsetZ, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    private static void addBubbleParticle(Vec3 pos, float size, ClientLevel level, float waterLevelY, Vec3 velocity) {
        double offsetX = (random.m_188500_() * 2.0 - 1.0) * (double)size;
        double offsetZ = (random.m_188500_() * 2.0 - 1.0) * (double)size;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ + offsetX, (double)waterLevelY, pos.f_82481_ + offsetZ, velocity.f_82479_, velocity.f_82480_ - random.m_188500_() * 0.2, velocity.f_82481_);
    }

    private static void playSplashSound(Vec3 pos) {
        float volumeModifier = 0.2f;
        float splashStrength = (float)Math.sqrt(pos.f_82479_ * pos.f_82479_ * 0.2 + pos.f_82480_ * pos.f_82480_ + pos.f_82481_ * pos.f_82481_ * 0.2) * volumeModifier;
        splashStrength = Math.min(1.0f, splashStrength);
        float pitch = 1.0f + (random.m_188501_() - random.m_188501_()) * 0.4f;
        EffectHelper.playSound(pos, SoundEvents.f_11917_, splashStrength, pitch);
    }

    public static void playSound(Vec3 pos, SoundEvent pSound, float pVolume, float pPitch) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), pSound, SoundSource.NEUTRAL, pVolume, pPitch);
    }
}

