/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility.backpack;

import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.util.helpers.context.AmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.ItemHandlerAmmoContext;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TravelersHelper {
    public static IAmmoContext findAmmo(Player player, AmmoHolder id) {
        IItemHandler inventory = TravelersHelper.getBackpackInventory(player);
        if (inventory == null) {
            return AmmoContext.NONE;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.isAmmo(stack, id)) continue;
            return new ItemHandlerAmmoContext(stack, inventory);
        }
        return AmmoContext.NONE;
    }

    public static IAmmoContext findMagazine(Player player, AmmoHolder id) {
        IItemHandler inventory = TravelersHelper.getBackpackInventory(player);
        if (inventory == null) {
            return AmmoContext.NONE;
        }
        ItemStack ammo = null;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.isAmmo(stack, id)) continue;
            if (stack.m_41773_() == 0) {
                return new ItemHandlerAmmoContext(stack, inventory);
            }
            if (ammo != null && (stack.m_41773_() >= ammo.m_41773_() || ammo.m_41773_() >= ammo.m_41776_())) continue;
            ammo = stack;
        }
        return ammo == null ? AmmoContext.NONE : new ItemHandlerAmmoContext(ammo, inventory);
    }

    @Nullable
    private static IItemHandler getBackpackInventory(Player player) {
        if (CapabilityUtils.isWearingBackpack((Player)player)) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper((Player)player);
            return wrapper.getStorage();
        }
        return null;
    }
}

