/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.trackers;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.tuple.Pair;

public class ShootTracker {
    private static final Map<Pair<LivingEntity, InteractionHand>, ShootTracker> SHOOT_TRACKER_MAP = new WeakHashMap<Pair<LivingEntity, InteractionHand>, ShootTracker>();
    private Pair<Long, Integer> cooldown = Pair.of((Object)0L, (Object)0);
    private final InteractionHand hand;

    public ShootTracker(InteractionHand hand) {
        this.hand = hand;
    }

    public static ShootTracker getShootTracker(LivingEntity entity, InteractionHand hand) {
        return SHOOT_TRACKER_MAP.computeIfAbsent((Pair<LivingEntity, InteractionHand>)Pair.of((Object)entity, (Object)hand), key -> new ShootTracker(hand));
    }

    public void putCooldown(WeaponData data) {
        int rate = WeaponModifierHelper.getRate(data);
        this.cooldown = Pair.of((Object)Util.m_137550_(), (Object)(rate * 50));
    }

    public boolean hasCooldown() {
        if (this.cooldown != null) {
            return Util.m_137550_() - (Long)this.cooldown.getLeft() < (long)((Integer)this.cooldown.getRight() - 50);
        }
        return false;
    }

    public boolean cooldownEnded() {
        if (this.cooldown != null) {
            long time = Util.m_137550_() - (Long)this.cooldown.getLeft();
            return time > (long)((Integer)this.cooldown.getRight()).intValue() && time < (long)((Integer)this.cooldown.getRight() + 50);
        }
        return false;
    }

    public long getRemaining() {
        if (this.cooldown != null) {
            return (long)((Integer)this.cooldown.getRight()).intValue() - (Util.m_137550_() - (Long)this.cooldown.getLeft());
        }
        return 0L;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

