/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.trackers;

import com.mojang.datafixers.util.Pair;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.ThrowableStateHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class ThrowingTracker {
    private static final Map<Pair<InteractionHand, LivingEntity>, Tracker> TRACKER_MAP = new HashMap<Pair<InteractionHand, LivingEntity>, Tracker>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                ThrowingTracker.onEntityTick((LivingEntity)player);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
                for (Pair<InteractionHand, LivingEntity> key : TRACKER_MAP.keySet()) {
                    LivingEntity entity = (LivingEntity)key.getSecond();
                    if (entity instanceof Player) continue;
                    ThrowingTracker.onEntityTick(entity);
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> {
                TRACKER_MAP.remove(Pair.of((Object)InteractionHand.MAIN_HAND, (Object)event.getEntity()));
                TRACKER_MAP.remove(Pair.of((Object)InteractionHand.OFF_HAND, (Object)event.getEntity()));
            });
        }
    }

    public static void start(WeaponData weaponData, InteractionHand arm) {
        assert (weaponData.wielder != null && weaponData.weapon != null);
        LivingEntity entity = weaponData.wielder;
        Pair key = Pair.of((Object)arm, (Object)entity);
        if (!TRACKER_MAP.containsKey(key) && !EquipTracker.isEquiping(weaponData.wielder, arm)) {
            if (!(weaponData.weapon.m_41720_() instanceof IThrowable)) {
                return;
            }
            TRACKER_MAP.put((Pair<InteractionHand, LivingEntity>)key, new Tracker(weaponData, arm, () -> TRACKER_MAP.remove(Pair.of((Object)arm, (Object)entity))));
        } else {
            ThrowingTracker.TRACKER_MAP.get((Object)key).released = false;
        }
    }

    public static void onRelease(WeaponData weaponData, InteractionHand arm) {
        Tracker tracker = TRACKER_MAP.get(Pair.of((Object)arm, (Object)weaponData.wielder));
        tracker.onRelease();
    }

    private static void onEntityTick(LivingEntity entity) {
        ThrowingTracker.handTick(entity, InteractionHand.MAIN_HAND);
        ThrowingTracker.handTick(entity, InteractionHand.OFF_HAND);
    }

    private static void handTick(LivingEntity shooter, InteractionHand arm) {
        Tracker tracker = TRACKER_MAP.get(Pair.of((Object)arm, (Object)shooter));
        if (tracker != null) {
            if (!tracker.isSameWeapon()) {
                tracker.stop();
            } else {
                tracker.tick();
            }
        }
    }

    private static class Tracker {
        private final WeaponData weaponData;
        private final InteractionHand arm;
        private final ItemStack stack;
        private final IThrowable throwable;
        private final int maxPrepare;
        private final int maxThrow;
        private final int maxLife;
        private final LivingEntity entity;
        private Runnable onStop;
        private boolean released = false;
        private int prepareTick;
        private int throwTick;
        private int lifeTick;

        private Tracker(WeaponData weaponData, InteractionHand arm, Runnable onStop) {
            this.weaponData = weaponData;
            this.arm = arm;
            this.entity = weaponData.wielder;
            this.onStop = onStop;
            this.stack = this.entity.m_21120_(arm);
            this.throwable = (IThrowable)this.stack.m_41720_();
            this.maxPrepare = WeaponModifierHelper.getPrepareTime(weaponData);
            this.maxThrow = WeaponModifierHelper.getThrowTime(weaponData);
            this.maxLife = WeaponModifierHelper.getThrowable(weaponData).getProjectile().getLife();
            this.prepareTick = this.maxPrepare;
            this.throwTick = this.maxThrow;
            this.lifeTick = this.maxLife;
            this.setPreparing(true);
            this.setThrowing(false);
        }

        public boolean isPreparing() {
            return (Boolean)ModSyncedDataKeys.getPreparingDataKey(this.arm).getValue((Entity)this.entity);
        }

        public boolean isThrowing() {
            return (Boolean)ModSyncedDataKeys.getThrowingDataKey(this.arm).getValue((Entity)this.entity);
        }

        public void setThrowing(boolean value) {
            ModSyncedDataKeys.getThrowingDataKey(this.arm).setValue((Entity)this.entity, (Object)value);
        }

        public void setPreparing(boolean value) {
            ModSyncedDataKeys.getPreparingDataKey(this.arm).setValue((Entity)this.entity, (Object)value);
        }

        public void setHolding(boolean value) {
            ModSyncedDataKeys.getHoldingDataKey(this.arm).setValue((Entity)this.entity, (Object)value);
        }

        public void tick() {
            if (!this.isSameWeapon()) {
                this.stop();
            }
            this.prepareTick = Math.max(this.prepareTick - 1, 0);
            if (this.prepareTick == 0) {
                if (ThrowableStateHelper.getThrowMode(this.weaponData) == ThrowMode.UNSAFE) {
                    this.lifeTick = Math.max(this.lifeTick - 1, 0);
                }
                if (!this.isThrowing()) {
                    if (this.released) {
                        this.setPreparing(false);
                        this.setThrowing(true);
                        this.setHolding(false);
                    } else {
                        this.setHolding(true);
                    }
                }
                if (this.lifeTick == 0) {
                    this.onExpire();
                } else if (this.isThrowing()) {
                    this.throwTick = Math.max(this.throwTick - 1, 0);
                }
                if (this.throwTick == 0) {
                    this.throwItem();
                    this.stop();
                }
            }
        }

        public void onRelease() {
            this.released = true;
        }

        private void throwItem() {
            this.throwable.throwItem(this.stack, this.entity, this.lifeTick);
        }

        private void onExpire() {
            this.throwable.expire(this.entity);
            this.stop();
        }

        private void stop() {
            this.onStop.run();
            this.setPreparing(false);
            this.setThrowing(false);
            this.setHolding(false);
        }

        private boolean isSameWeapon() {
            ItemStack heldItem = this.entity.m_21120_(this.arm);
            return !this.stack.m_41619_() && heldItem == this.stack;
        }
    }
}

