/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.world;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.data.config.weapon.ExplosionConfig;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileExplosion;
import com.nukateam.ntgl.common.util.interfaces.IExplosionDamageable;
import com.nukateam.ntgl.common.util.world.ProjectileExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ExplosionUtils {
    public static boolean isExplosive(ExplosionConfig config) {
        return config.getRadius() > 0.0f;
    }

    public static void createExplosion(@NotNull Entity entity, @NotNull ExplosionConfig config, Vec3 hitPos) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_() || hitPos == null || config.getRadius() <= 0.0f) {
            return;
        }
        entity.m_146884_(hitPos);
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectileEntity = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectileEntity.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = config.isDestroyBlocks() && (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, config, hitPos, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20238_(hitPos) < 4096.0)) continue;
            PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageProjectileExplosion(hitPos, (Vec3)explosion.m_46078_().get(player), config, explosion.m_46081_()));
        }
    }
}

