/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateWeapons;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import com.nukateam.ntgl.modules.datapack.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkWeaponManager
extends SimplePreparableReloadListener<Map<IWeapon, WeaponConfig>> {
    private static final List<IWeapon> clientRegisteredWeapons = new ArrayList<IWeapon>();
    private static NetworkWeaponManager instance;
    private Map<ResourceLocation, WeaponConfig> registeredWeapons = new HashMap<ResourceLocation, WeaponConfig>();

    public static void onServerStopped() {
        instance = null;
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkWeaponManager networkWeaponManager = new NetworkWeaponManager();
        event.addListener((PreparableReloadListener)networkWeaponManager);
        instance = networkWeaponManager;
    }

    protected Map<IWeapon, WeaponConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return DataUtils.getConfigMap(manager, v -> v instanceof IWeapon, WeaponConfig.class, "weapons");
    }

    protected void apply(Map<IWeapon, WeaponConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((abstractItem, gun) -> {
            if (abstractItem instanceof Item) {
                Item item = (Item)abstractItem;
                Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)item));
                builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)item), gun);
                abstractItem.setConfig(new ConfigSupplier<WeaponConfig>((WeaponConfig)gun));
            }
        });
        this.registeredWeapons = builder.build();
    }

    public void writeRegisteredGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredWeapons.size());
        this.registeredWeapons.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, WeaponConfig> readRegisteredWeapons(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                WeaponConfig weaponConfig = WeaponConfig.create(id, buffer.m_130260_());
                builder.put((Object)id, (Object)weaponConfig);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredWeapons(S2CMessageUpdateWeapons message) {
        return NetworkWeaponManager.updateRegisteredWeapons(message.getRegisteredGuns());
    }

    private static boolean updateRegisteredWeapons(Map<ResourceLocation, WeaponConfig> registeredConfigs) {
        clientRegisteredWeapons.clear();
        if (registeredConfigs != null) {
            for (Map.Entry<ResourceLocation, WeaponConfig> entry : registeredConfigs.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof IWeapon)) {
                    return false;
                }
                ((IWeapon)item).setConfig(new ConfigSupplier<WeaponConfig>(entry.getValue()));
                clientRegisteredWeapons.add((IWeapon)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, WeaponConfig> getRegisteredWeapons() {
        return this.registeredWeapons;
    }

    public static List<IWeapon> getClientRegisteredWeapons() {
        return ImmutableList.copyOf(clientRegisteredWeapons);
    }

    @Nullable
    public static NetworkWeaponManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkWeaponManager.get()));
            NetworkWeaponManager.get().writeRegisteredGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, WeaponConfig> registeredGuns = NetworkWeaponManager.readRegisteredWeapons(buffer);
            NetworkWeaponManager.updateRegisteredWeapons(registeredGuns);
            return Optional.empty();
        }
    }
}

