/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoObjectRenderer;

public class GeoItemEntityRenderer<T extends GeoAnimatable>
extends GeoObjectRenderer<T> {
    private ItemStack currentItemStack;
    private ItemDisplayContext currentTransform;

    public GeoItemEntityRenderer(GeoModel<T> model) {
        super(model);
    }

    public void render(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, T animatable, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        this.currentItemStack = stack;
        this.currentTransform = transformType;
        super.render(poseStack, animatable, bufferSource, renderType, buffer, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        boolean shouldSit = false;
        float lerpBodyRot = 0.0f;
        float lerpHeadRot = 0.0f;
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!isReRender) {
            int headPitch = 0;
            boolean motionThreshold = false;
            Vec3 velocity = Vec3.f_82478_;
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            AnimationState animationState = new AnimationState(animatable, limbSwing, limbSwingAmount, partialTick, avgVelocity >= (float)motionThreshold && limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId((GeoAnimatable)animatable);
            animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, (Object)this.currentTransform);
            animationState.setData(DataTickets.ITEMSTACK, (Object)this.currentItemStack);
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick(animatable));
            animationState.setData(DataTickets.ENTITY, null);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(shouldSit, false, -netHeadYaw, (float)(-headPitch)));
            GeoModel var31 = this.model;
            Objects.requireNonNull(animationState);
            var31.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

