/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.nukateam.example.common.registery.ExampleWeapons;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.client.util.handler.ControllerHandler;
import com.nukateam.ntgl.client.util.handler.GunRenderingHandler;
import com.nukateam.ntgl.client.util.helpers.PropertyHelper;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.config.weapon.Zoom;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageAim;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerReviveHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import com.nukateam.ntgl.modules.gunpack.regestry.ModBlocks;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AimingHandler {
    private static AimingHandler instance;
    private WeaponData weaponData = new WeaponData(new ItemStack((ItemLike)ExampleWeapons.CLASSIC10MM.get()), null);
    private static final double MAX_AIM_PROGRESS = 5.0;
    private final AimTracker localTracker = new AimTracker();
    private final Map<Player, AimTracker> aimingMap = new WeakHashMap<Player, AimTracker>();
    private double normalisedAdsProgress;
    private boolean aiming = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    private AimingHandler() {
    }

    public static boolean isAiming(ItemStack gun) {
        Minecraft minecraft = Minecraft.m_91087_();
        float progress = AimingHandler.get().getAimProgress((LivingEntity)minecraft.f_91074_, minecraft.m_91296_());
        return gun.m_41720_() instanceof IWeapon && AimingHandler.get().isAiming() && progress == 1.0f;
    }

    public static boolean isScoping(ItemStack gun) {
        return AimingHandler.isAiming(gun) && WeaponStateHelper.hasScopeOverlay(gun);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41720_() instanceof IWeapon) {
                WeaponData weaponData = new WeaponData(heldItem, (LivingEntity)player);
                tracker.handleAiming(weaponData);
            }
            if (!tracker.isAiming()) {
                this.aimingMap.remove(player);
            }
        }
    }

    @Nullable
    private AimTracker getAimTracker(Player player) {
        boolean isAiming = true;
        try {
            isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (isAiming && !this.aimingMap.containsKey(player)) {
            this.aimingMap.put(player, new AimTracker());
        }
        return this.aimingMap.get(player);
    }

    public float getAimProgress(LivingEntity entity, float partialTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7578_()) {
                return (float)this.localTracker.getNormalProgress(partialTicks);
            }
            AimTracker tracker = this.getAimTracker(player);
            if (tracker != null) {
                return (float)tracker.getNormalProgress(partialTicks);
            }
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41720_() instanceof IWeapon) {
            this.weaponData = new WeaponData(heldItem, (LivingEntity)player);
            if (this.isAiming()) {
                if (!this.aiming) {
                    ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer(new C2SMessageAim(true));
                    this.aiming = true;
                }
            } else if (this.aiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer(new C2SMessageAim(false));
                this.aiming = false;
            }
            this.localTracker.handleAiming(this.weaponData);
        }
    }

    @SubscribeEvent
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        if (!GunRenderingHandler.get().getUsedConfiguredFov()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_21205_().m_41619_() || mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof IWeapon)) {
            return;
        }
        if (AimingHandler.get().getNormalisedAdsProgress() == 0.0) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return;
        }
        Zoom zoom = WeaponModifierHelper.getZoom(this.weaponData);
        if (zoom == null) {
            return;
        }
        double time = PropertyHelper.getSightAnimations(heldItem).getFovCurve().apply(this.normalisedAdsProgress);
        float modifier = WeaponStateHelper.getFovModifier(this.weaponData);
        modifier = (1.0f - modifier) * (float)time;
        event.setFOV(event.getFOV() - event.getFOV() * (double)modifier);
    }

    @SubscribeEvent
    public void onClientTick(ClientPlayerNetworkEvent.LoggingOut event) {
        this.aimingMap.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTick());
    }

    public boolean isZooming() {
        return this.aiming;
    }

    public WeaponData getWeaponData() {
        return this.weaponData;
    }

    public boolean isAiming() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_5833_()) {
            return false;
        }
        if (Debug.isForceAim()) {
            return true;
        }
        if (mc.f_91080_ != null || PlayerReviveHelper.isBleeding((Player)mc.f_91074_)) {
            return false;
        }
        ItemStack mainHandItem = mc.f_91074_.m_21205_();
        ItemStack offhandItem = mc.f_91074_.m_21206_();
        if (!(mainHandItem.m_41720_() instanceof IWeapon)) {
            return false;
        }
        boolean mainOneHanded = WeaponModifierHelper.isOneHanded(new WeaponData(mainHandItem, (LivingEntity)mc.f_91074_));
        boolean offOneHanded = WeaponModifierHelper.isOneHanded(new WeaponData(offhandItem, (LivingEntity)mc.f_91074_));
        if (!mainHandItem.m_41619_() && !offhandItem.m_41619_() && mainOneHanded && offOneHanded) {
            return false;
        }
        WeaponConfig gun = ((IWeapon)mainHandItem.m_41720_()).getModifiedConfig(mainHandItem);
        if (mc.f_91074_.m_21206_().m_41720_() == Items.f_42740_ && WeaponModifierHelper.isOneHanded(new WeaponData(mainHandItem, (LivingEntity)mc.f_91074_))) {
            return false;
        }
        if (!this.localTracker.isAiming() && this.isLookingAtInteractableBlock()) {
            return false;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return false;
        }
        if (mainHandItem.m_41720_() instanceof IWeapon && offhandItem.m_41720_() instanceof IWeapon) {
            GripType off = WeaponModifierHelper.getGripType(new WeaponData(offhandItem, (LivingEntity)mc.f_91074_));
            if (off.isOneHanded()) {
                return false;
            }
            return false;
        }
        return this.isAimKeyDown(this.weaponData);
    }

    private boolean isAimKeyDown(WeaponData data) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92096_.m_90857_()) {
            data.setWeaponMode(WeaponMode.PRIMARY);
            if (AimingHandler.isScopeAction(data)) {
                return true;
            }
        }
        if (mc.f_91066_.f_92095_.m_90857_()) {
            data.setWeaponMode(WeaponMode.SECONDARY);
            if (AimingHandler.isScopeAction(data)) {
                return true;
            }
        }
        if (NtglKeyBinds.KEY_ADD_ATTACK.m_90857_()) {
            data.setWeaponMode(WeaponMode.ADDITIONAL);
            if (AimingHandler.isScopeAction(data)) {
                return true;
            }
        }
        if (NtglKeyBinds.KEY_ALT_ATTACK.m_90857_()) {
            data.setWeaponMode(WeaponMode.ALTERNATIVE);
            if (AimingHandler.isScopeAction(data)) {
                return true;
            }
        }
        return Ntgl.controllableLoaded && ControllerHandler.isAiming();
    }

    private static boolean isScopeAction(WeaponData data) {
        return WeaponModifierHelper.getWeaponAction(data) == WeaponAction.SCOPE;
    }

    public boolean isLookingAtInteractableBlock() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ != null && mc.f_91073_ != null) {
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockState state = mc.f_91073_.m_8055_(result.m_82425_());
                Block block = state.m_60734_();
                return block instanceof EntityBlock || block == Blocks.f_50091_ || block == ModBlocks.WORKBENCH.get() || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(Tags.Blocks.CHESTS) || state.m_204336_(Tags.Blocks.FENCE_GATES);
            }
            hitResult = mc.f_91077_;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult result = (EntityHitResult)hitResult;
                return result.m_82443_() instanceof ItemFrame;
            }
        }
        return false;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public class AimTracker {
        private double currentAim;
        private double previousAim;

        private void handleAiming(WeaponData weaponData) {
            assert (weaponData.weapon != null && weaponData.wielder instanceof Player);
            ItemStack heldItem = weaponData.weapon;
            Player player = (Player)weaponData.wielder;
            if (!(heldItem.m_41720_() instanceof IWeapon)) {
                return;
            }
            this.previousAim = this.currentAim;
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() || player.m_7578_() && AimingHandler.this.isAiming()) {
                if (this.currentAim < 5.0) {
                    double speed = WeaponModifierHelper.getModifiedAimDownSightSpeed(weaponData);
                    this.currentAim += speed;
                    if (this.currentAim > 5.0) {
                        this.currentAim = 5.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                double speed = WeaponModifierHelper.getModifiedAimDownSightSpeed(weaponData);
                this.currentAim -= speed;
                if (this.currentAim < 0.0) {
                    this.currentAim = 0.0;
                }
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        public double getNormalProgress(float partialTicks) {
            return Mth.m_14008_((double)((this.previousAim + (this.currentAim - this.previousAim) * (double)partialTicks) / 5.0), (double)0.0, (double)1.0);
        }
    }
}

