/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.weapon.ExplosionConfig;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.data.json.JsonDeserializers;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.foundation.init.NtglDamageTypes;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectileConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    private float damage = 1.0f;
    private float size;
    @Optional
    private float speed = 20.0f;
    private int life = 20;
    @Optional
    private ProjectileType projectile = ProjectileType.BULLET;
    @Optional
    private ResourceKey<DamageType> damageType = NtglDamageTypes.BULLET;
    @Optional
    private boolean visible;
    @Optional
    private boolean gravity;
    @Optional
    private boolean affectedByFluid = true;
    @Optional
    private boolean damageReduceOverLife;
    @Optional
    private boolean magazineMode;
    @Optional
    private int trailColor = 16765577;
    @Optional
    private double trailLengthMultiplier = 1.0;
    @Optional
    int projectileAmount = 1;
    @Optional
    float spread;
    @Optional
    int pierceLevel = 0;
    @Optional
    int burnSeconds = 0;
    @Optional
    ExplosionConfig explosion = new ExplosionConfig();
    @Optional
    @Nullable
    ResourceLocation hitSound;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Projectile", this.projectile.toString());
        tag.m_128359_("DamageType", this.damageType.m_135782_().toString());
        tag.m_128350_("Damage", this.damage);
        tag.m_128379_("Visible", this.visible);
        tag.m_128350_("Size", this.size);
        tag.m_128350_("Speed", this.speed);
        tag.m_128405_("Life", this.life);
        tag.m_128379_("Gravity", this.gravity);
        tag.m_128379_("affectedByFluid", this.affectedByFluid);
        tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
        tag.m_128379_("MagazineMode", this.magazineMode);
        tag.m_128405_("TrailColor", this.trailColor);
        tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
        tag.m_128405_("ProjectileAmount", this.projectileAmount);
        tag.m_128350_("Spread", this.spread);
        tag.m_128405_("pierceLevel", this.pierceLevel);
        tag.m_128405_("burnSeconds", this.burnSeconds);
        tag.m_128365_("explosion", (Tag)this.explosion.serializeNBT());
        if (this.hitSound != null) {
            tag.m_128359_("hitSound", this.hitSound.toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Visible", 99)) {
            this.visible = tag.m_128471_("Visible");
        }
        if (tag.m_128425_("DamageType", 8)) {
            this.damageType = JsonDeserializers.getDamageTypeResourceKey(tag.m_128461_("DamageType"));
        }
        if (tag.m_128425_("Damage", 99)) {
            this.damage = tag.m_128457_("Damage");
        }
        if (tag.m_128425_("Size", 99)) {
            this.size = tag.m_128457_("Size");
        }
        if (tag.m_128425_("Speed", 99)) {
            this.speed = tag.m_128457_("Speed");
        }
        if (tag.m_128425_("Life", 99)) {
            this.life = tag.m_128451_("Life");
        }
        if (tag.m_128425_("pierceLevel", 99)) {
            this.pierceLevel = tag.m_128451_("pierceLevel");
        }
        if (tag.m_128425_("burnSeconds", 99)) {
            this.burnSeconds = tag.m_128451_("burnSeconds");
        }
        if (tag.m_128425_("Gravity", 99)) {
            this.gravity = tag.m_128471_("Gravity");
        }
        if (tag.m_128425_("affectedByFluid", 99)) {
            this.affectedByFluid = tag.m_128471_("affectedByFluid");
        }
        if (tag.m_128425_("DamageReduceOverLife", 99)) {
            this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
        }
        if (tag.m_128425_("MagazineMode", 99)) {
            this.magazineMode = tag.m_128471_("MagazineMode");
        }
        if (tag.m_128425_("TrailColor", 99)) {
            this.trailColor = tag.m_128451_("TrailColor");
        }
        if (tag.m_128425_("TrailLengthMultiplier", 99)) {
            this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
        }
        if (tag.m_128425_("Projectile", 8)) {
            this.projectile = ProjectileType.getType(tag.m_128461_("Projectile"));
        }
        if (tag.m_128425_("ProjectileAmount", 99)) {
            this.projectileAmount = tag.m_128451_("ProjectileAmount");
        }
        if (tag.m_128425_("Spread", 99)) {
            this.spread = tag.m_128457_("Spread");
        }
        if (tag.m_128425_("explosion", 10)) {
            this.explosion = ExplosionConfig.create(tag.m_128469_("explosion"));
        }
        if (tag.m_128425_("hitSound", 8)) {
            this.hitSound = ResourceLocation.m_135820_((String)tag.m_128461_("hitSound"));
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
        Preconditions.checkArgument((this.size >= 0.0f ? 1 : 0) != 0, (Object)"Projectile size must be more than or equal to zero");
        Preconditions.checkArgument(((double)this.speed >= 0.0 ? 1 : 0) != 0, (Object)"Projectile speed must be more than or equal to zero");
        Preconditions.checkArgument((this.life > 0 ? 1 : 0) != 0, (Object)"Projectile life must be more than zero");
        Preconditions.checkArgument((this.trailLengthMultiplier >= 0.0 ? 1 : 0) != 0, (Object)"Projectile trail length multiplier must be more than or equal to zero");
        Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
        Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
        JsonObject object = new JsonObject();
        if (this.visible) {
            object.addProperty("visible", Boolean.valueOf(true));
        }
        object.addProperty("damage", (Number)Float.valueOf(this.damage));
        object.addProperty("size", (Number)Float.valueOf(this.size));
        object.addProperty("speed", (Number)Float.valueOf(this.speed));
        object.addProperty("life", (Number)this.life);
        object.addProperty("pierceLevel", (Number)this.pierceLevel);
        object.addProperty("burnSeconds", (Number)this.burnSeconds);
        object.addProperty("projectile", this.projectile.toString());
        object.addProperty("damageType", this.damageType.m_135782_().toString());
        object.addProperty("hitSound", this.hitSound.toString());
        GunJsonUtil.addObjectIfNotEmpty(object, "explosion", this.explosion.toJsonObject());
        if (this.gravity) {
            object.addProperty("gravity", Boolean.valueOf(true));
        }
        object.addProperty("affectedByFluid", Boolean.valueOf(true));
        object.addProperty("damageReduceOverLife", Boolean.valueOf(this.damageReduceOverLife));
        object.addProperty("magazineMode", Boolean.valueOf(this.magazineMode));
        if (this.trailColor != 16765577) {
            object.addProperty("trailColor", (Number)this.trailColor);
        }
        if (this.trailLengthMultiplier != 1.0) {
            object.addProperty("trailLengthMultiplier", (Number)this.trailLengthMultiplier);
        }
        if (this.projectileAmount != 1) {
            object.addProperty("projectileAmount", (Number)this.projectileAmount);
        }
        if (this.spread != 0.0f) {
            object.addProperty("spread", (Number)Float.valueOf(this.spread));
        }
        return object;
    }

    public ProjectileConfig copy() {
        ProjectileConfig projectile = new ProjectileConfig();
        projectile.visible = this.visible;
        projectile.damage = this.damage;
        projectile.size = this.size;
        projectile.speed = this.speed;
        projectile.life = this.life;
        projectile.pierceLevel = this.pierceLevel;
        projectile.burnSeconds = this.burnSeconds;
        projectile.gravity = this.gravity;
        projectile.affectedByFluid = this.affectedByFluid;
        projectile.damageReduceOverLife = this.damageReduceOverLife;
        projectile.magazineMode = this.magazineMode;
        projectile.trailColor = this.trailColor;
        projectile.trailLengthMultiplier = this.trailLengthMultiplier;
        projectile.projectile = this.projectile;
        projectile.damageType = this.damageType;
        projectile.projectileAmount = this.projectileAmount;
        projectile.spread = this.spread;
        projectile.explosion = this.explosion;
        projectile.hitSound = this.hitSound;
        return projectile;
    }

    public ExplosionConfig getExplosion() {
        return this.explosion;
    }

    @Nullable
    public ResourceLocation getHitSound() {
        return this.hitSound;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getLife() {
        return this.life;
    }

    public int getPierceLevel() {
        return this.pierceLevel;
    }

    public int getBurnSeconds() {
        return this.burnSeconds;
    }

    public boolean isGravity() {
        return this.gravity;
    }

    public boolean affectedByFluid() {
        return this.affectedByFluid;
    }

    public boolean isDamageReduceOverLife() {
        return this.damageReduceOverLife;
    }

    public boolean isMagazineMode() {
        return this.magazineMode;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getProjectileAmount() {
        return this.projectileAmount;
    }

    public float getSpread() {
        return this.spread;
    }

    public ProjectileType getProjectileType() {
        return this.projectile;
    }

    public ResourceKey<DamageType> getDamageType() {
        return this.damageType;
    }

    public static ProjectileConfig create(CompoundTag tag) {
        ProjectileConfig ammo = new ProjectileConfig();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Projectile");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final ProjectileConfig projectile;

        private Builder() {
            this.projectile = new ProjectileConfig();
        }

        private Builder(ProjectileConfig projectile) {
            this.projectile = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ProjectileConfig projectile) {
            return new Builder(projectile);
        }

        public ProjectileConfig build() {
            return this.projectile.copy();
        }

        public Builder setProjectileVisible(boolean visible) {
            this.projectile.visible = visible;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.projectile.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setProjectileSize(float size) {
            this.projectile.size = size;
            return this;
        }

        public Builder setProjectileSpeed(float speed) {
            this.projectile.speed = speed;
            return this;
        }

        public Builder setProjectileLife(int life) {
            this.projectile.life = life;
            return this;
        }

        public Builder setPierceLevel(int pierceLevel) {
            this.projectile.pierceLevel = pierceLevel;
            return this;
        }

        public Builder setProjectileAffectedByGravity(boolean gravity) {
            this.projectile.gravity = gravity;
            return this;
        }

        public Builder setProjectileTrailColor(int trailColor) {
            this.projectile.trailColor = trailColor;
            return this;
        }

        public Builder setProjectileTrailLengthMultiplier(int trailLengthMultiplier) {
            this.projectile.trailLengthMultiplier = trailLengthMultiplier;
            return this;
        }

        public Builder setDamage(float damage) {
            this.projectile.damage = damage;
            return this;
        }

        public Builder setSpread(float spread) {
            this.projectile.spread = spread;
            return this;
        }

        public Builder setReduceDamageOverLife(boolean damageReduceOverLife) {
            this.projectile.damageReduceOverLife = damageReduceOverLife;
            return this;
        }

        public Builder setMagazineMode(boolean magazineMode) {
            this.projectile.magazineMode = magazineMode;
            return this;
        }

        public Builder setExplosionConfig(ExplosionConfig explosion) {
            this.projectile.explosion = explosion;
            return this;
        }

        public Builder setProjectileType(ProjectileType projectile) {
            this.projectile.projectile = projectile;
            return this;
        }
    }
}

