/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.AmmoData;
import com.nukateam.ntgl.common.data.config.weapon.Fuel;
import com.nukateam.ntgl.common.data.config.weapon.General;
import com.nukateam.ntgl.common.data.config.weapon.Melee;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.weapon.ThrowableConfig;
import com.nukateam.ntgl.common.data.config.weapon.Zoom;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponSettings
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String GENERAL = "General";
    public static final String MELEE = "Melee";
    public static final String THROWABLE = "Throwable";
    public static final String AMMO_DATA = "AmmoData";
    public static final String SECONDARY_AMMO = "SecondaryAmmo";
    public static final String ZOOM = "Zoom";
    protected General general = new General();
    protected Melee melee = new Melee();
    protected ThrowableConfig throwable = new ThrowableConfig();
    protected LinkedHashMap<ResourceLocation, AmmoData> ammoData = new LinkedHashMap();
    protected LinkedHashMap<ResourceLocation, Fuel> fuel = new LinkedHashMap();
    @Optional
    @Nullable
    protected Zoom zoom = new Zoom();

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(GENERAL, (Tag)this.general.serializeNBT());
        tag.m_128365_(MELEE, (Tag)this.melee.serializeNBT());
        tag.m_128365_(THROWABLE, (Tag)this.throwable.serializeNBT());
        tag.m_128365_(AMMO_DATA, (Tag)NbtUtils.serializeMap(this.ammoData));
        tag.m_128365_(SECONDARY_AMMO, (Tag)NbtUtils.serializeMap(this.fuel));
        if (this.zoom != null) {
            tag.m_128365_(ZOOM, (Tag)this.zoom.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(GENERAL, 10)) {
            this.general.deserializeNBT(tag.m_128469_(GENERAL));
        }
        if (tag.m_128425_(MELEE, 10)) {
            this.melee.deserializeNBT(tag.m_128469_(MELEE));
        }
        if (tag.m_128425_(THROWABLE, 10)) {
            this.throwable.deserializeNBT(tag.m_128469_(THROWABLE));
        }
        if (tag.m_128425_(AMMO_DATA, 10)) {
            this.ammoData = NbtUtils.deserializeLinkedMap(tag.m_128469_(AMMO_DATA), nbt -> AmmoData.create(nbt));
        }
        if (tag.m_128425_(SECONDARY_AMMO, 10)) {
            this.fuel = NbtUtils.deserializeLinkedMap(tag.m_128469_(SECONDARY_AMMO), nbt -> Fuel.create(nbt));
        }
        if (tag.m_128425_(ZOOM, 10)) {
            this.zoom = Zoom.create(tag.m_128469_(ZOOM));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("melee", (JsonElement)this.melee.toJsonObject());
        object.add("throwable", (JsonElement)this.throwable.toJsonObject());
        object.add("zoom", (JsonElement)this.zoom.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "ammoData", gson.toJsonTree(this.ammoData).getAsJsonObject());
        return object;
    }

    public WeaponSettings copy() {
        WeaponSettings gun = new WeaponSettings();
        gun.general = this.general.copy();
        gun.melee = this.melee.copy();
        gun.throwable = this.throwable.copy();
        gun.zoom = this.zoom.copy();
        gun.ammoData = (LinkedHashMap)this.ammoData.clone();
        gun.fuel = (LinkedHashMap)this.fuel.clone();
        return gun;
    }

    public static WeaponSettings create(CompoundTag tag) {
        WeaponSettings gun = new WeaponSettings();
        gun.deserializeNBT(tag);
        return gun;
    }

    public General getGeneral() {
        return this.general;
    }

    public Melee getMelee() {
        return this.melee;
    }

    public ThrowableConfig getThrowable() {
        return this.throwable;
    }

    public AmmoData getAmmoData(ResourceLocation ammo) {
        return this.ammoData.getOrDefault(ammo, new AmmoData());
    }

    public Fuel getFuelData(ResourceLocation ammo) {
        return this.fuel.getOrDefault(ammo, new Fuel());
    }

    public boolean hasAmmo(ResourceLocation ammo) {
        return this.ammoData.containsKey(ammo);
    }

    @Nullable
    public Zoom getZoom() {
        return this.zoom;
    }

    public ProjectileConfig getProjectileConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getProjectile();
    }

    public AmmoConfig getAmmoConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getAmmo();
    }

    public Fuel getFuelConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo);
    }

    public AmmoConfig getFuelAmmoConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo).getAmmo();
    }

    public static class Builder {
        private final WeaponSettings gun;

        private Builder() {
            this.gun = new WeaponSettings();
        }

        private Builder(WeaponSettings gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(WeaponSettings gun) {
            return new Builder(gun);
        }

        public WeaponSettings build() {
            return this.gun.copy();
        }

        public Builder addAmmo(AmmoHolder id) {
            this.gun.general.ammo.add(id);
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.general.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.general.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setReloadTime(int reloadTime) {
            this.gun.general.reloadTime = reloadTime;
            return this;
        }

        public Builder setLoadingType(LoadingType loadingType) {
            this.gun.general.loadingType = loadingType;
            return this;
        }

        public Builder setCategory(String category) {
            this.gun.general.category = category;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }
    }
}

