/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.General;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.event.GunProjectileHitEvent;
import com.nukateam.ntgl.common.foundation.ModTags;
import com.nukateam.ntgl.common.foundation.entity.HitTarget;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageBlood;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitBlock;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitEntity;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitFluid;
import com.nukateam.ntgl.common.util.helpers.EntityResult;
import com.nukateam.ntgl.common.util.helpers.RayTraceHelper;
import com.nukateam.ntgl.common.util.interfaces.IDamageable;
import com.nukateam.ntgl.common.util.interfaces.IHeadshotBox;
import com.nukateam.ntgl.common.util.managers.BoundingBoxManager;
import com.nukateam.ntgl.common.util.trackers.SpreadTracker;
import com.nukateam.ntgl.common.util.util.BufferUtil;
import com.nukateam.ntgl.common.util.util.ReflectionUtil;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import com.nukateam.ntgl.common.util.util.math.ExtendedEntityRayTraceResult;
import com.nukateam.ntgl.common.util.world.ExplosionUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    protected static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    protected static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected WeaponMode weaponAction;
    protected WeaponData weaponData;
    protected boolean isServerSide = !this.m_9236_().m_5776_();
    protected boolean isRightHand;
    protected int shooterId;
    protected LivingEntity shooter;
    protected General general;
    protected ProjectileConfig projectile = new ProjectileConfig();
    protected ItemStack weapon = ItemStack.f_41583_;
    protected ItemStack ammo = ItemStack.f_41583_;
    protected EntityDimensions entitySize;
    protected double modifiedGravity;
    protected int life;
    protected int pierceCount;
    private BlockPos hitBlockpos = BlockPos.f_121853_;

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level level, WeaponData data) {
        this(entityType, level);
        IWeapon item = (IWeapon)data.weapon.m_41720_();
        ItemStack weaponStack = data.weapon;
        this.weaponData = data;
        this.shooter = data.wielder;
        this.weaponAction = data.weaponMode;
        this.shooterId = this.shooter.m_19879_();
        this.weapon = weaponStack;
        this.general = WeaponModifierHelper.getGeneral(data);
        this.projectile = WeaponStateHelper.getProjectileConfig(data);
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.m_20011_(new AABB((double)this.projectile.getSize(), (double)this.projectile.getSize(), (double)this.projectile.getSize(), (double)(-this.projectile.getSize()), (double)(-this.projectile.getSize()), (double)(-this.projectile.getSize())));
        this.modifiedGravity = WeaponModifierHelper.getProjectileGravity(data, -0.04);
        this.life = WeaponModifierHelper.getProjectileLife(data, this.projectile.getLife());
        InteractionHand hand = this.shooter.m_21205_() == weaponStack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.isRightHand = hand == InteractionHand.MAIN_HAND;
        this.ammo = this.setupAmmo(data);
        this.pierceCount = this.projectile.getPierceLevel();
        Vec3 dir = this.getDirection(this.shooter, weaponStack, item);
        float speed = this.projectile.getSpeed();
        this.m_20334_(dir.f_82479_ * (double)speed, dir.f_82480_ * (double)speed, dir.f_82481_ * (double)speed);
        this.updateHeading();
        this.setupDirection(this.shooter, weaponStack, item);
        this.setupStartPosition(this.shooter);
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Weapon", (Tag)this.weapon.m_41739_(new CompoundTag()));
        compound.m_128359_("WeaponAction", this.weaponAction.toString());
        compound.m_128365_("Ammo", (Tag)this.ammo.m_41739_(new CompoundTag()));
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128365_("General", (Tag)this.general.serializeNBT());
        compound.m_128347_("ModifiedGravity", this.modifiedGravity);
        compound.m_128405_("MaxLife", this.life);
        compound.m_128379_("IsRightHand", this.isRightHand);
    }

    protected void m_7378_(CompoundTag compound) {
        this.weapon = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Weapon"));
        this.weaponAction = WeaponMode.getType(compound.m_128461_("WeaponAction"));
        this.ammo = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Ammo"));
        this.projectile = ProjectileConfig.create(compound.m_128469_("Projectile"));
        this.general = General.create(compound.m_128469_("General"));
        this.modifiedGravity = compound.m_128459_("ModifiedGravity");
        this.life = compound.m_128451_("MaxLife");
        this.isRightHand = compound.m_128471_("IsRightHand");
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.m_130079_(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.ammo);
        buffer.writeDouble(this.modifiedGravity);
        buffer.m_130130_(this.life);
        buffer.writeBoolean(this.isRightHand);
        buffer.m_130070_(this.weaponAction.toString());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = ProjectileConfig.create(buffer.m_130260_());
        this.general = General.create(buffer.m_130260_());
        this.shooterId = buffer.readInt();
        this.ammo = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.m_130242_();
        this.isRightHand = buffer.readBoolean();
        this.weaponAction = WeaponMode.getType(buffer.m_130277_());
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.m_20011_(new AABB((double)this.projectile.getSize(), (double)this.projectile.getSize(), (double)this.projectile.getSize(), (double)(-this.projectile.getSize()), (double)(-this.projectile.getSize()), (double)(-this.projectile.getSize())));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.entitySize;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHeading();
        this.onProjectileTick();
        if (this.isServerSide) {
            this.rayTraceTargets();
        }
        this.travel();
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected double getGravity() {
        return this.projectile.isGravity() || this.isAffectedByFluid() ? this.modifiedGravity : 0.0;
    }

    private boolean isAffectedByFluid() {
        return this.projectile.affectedByFluid() && this.isInFluidType();
    }

    public boolean isVisible() {
        return this.projectile.isVisible();
    }

    public boolean isRightHand() {
        return this.isRightHand;
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.m_41777_();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.ammo = item;
    }

    public ItemStack getItem() {
        return this.ammo;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public int getLife() {
        return this.projectile.getLife();
    }

    public ProjectileConfig getProjectile() {
        return this.projectile;
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getDamage() {
        if (this.weapon.m_41619_()) {
            return 0.0f;
        }
        WeaponData data = new WeaponData(this.weapon, this.shooter);
        float initialDamage = WeaponModifierHelper.getProjectileDamage(ForgeRegistries.ITEMS.getKey((Object)this.ammo.m_41720_()), data);
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.f_19797_ - 1)) / (float)this.projectile.getLife();
            initialDamage *= modifier;
        }
        int projectileAmount = WeaponModifierHelper.getProjectileAmount(data);
        float damage = initialDamage / (float)projectileAmount;
        return Math.max(0.0f, damage);
    }

    protected void travel() {
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity() || this.isAffectedByFluid()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.getGravity(), 0.0));
        }
        if (this.isAffectedByFluid()) {
            Vec3 motion = this.m_20184_();
            double drag = this.getFluidDrag();
            this.m_20334_(motion.f_82479_ * drag, motion.f_82480_ * drag, motion.f_82481_ * drag);
        }
    }

    protected void rayTraceTargets() {
        List<EntityResult> hitEntities;
        BlockHitResult result;
        Vec3 endVec;
        Vec3 startVec;
        block8: {
            block9: {
                startVec = this.m_20182_();
                endVec = startVec.m_82549_(this.m_20184_());
                result = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this), this.getBlockFilter());
                if (result.m_6662_() == HitResult.Type.MISS) break block8;
                if (!(result instanceof BlockHitResult)) break block9;
                BlockHitResult bhr = result;
                if (!this.m_9236_().m_8055_(bhr.m_82425_()).m_60819_().m_76178_()) break block8;
            }
            endVec = result.m_82450_();
        }
        if ((hitEntities = this.getHitEntityResult(startVec, endVec)) != null && !hitEntities.isEmpty()) {
            for (EntityResult hit : hitEntities) {
                ExtendedEntityRayTraceResult entityHitResult = new ExtendedEntityRayTraceResult(hit);
                Entity entity = entityHitResult.m_82443_();
                if (entity instanceof Player) {
                    Player playerShooter;
                    Player playerTarget = (Player)entity;
                    LivingEntity livingEntity = this.shooter;
                    if (livingEntity instanceof Player && !(playerShooter = (Player)livingEntity).m_7099_(playerTarget)) {
                        entityHitResult = null;
                    }
                }
                if (entityHitResult == null) continue;
                this.onHit((HitResult)entityHitResult, startVec, endVec);
            }
        } else {
            this.onHit((HitResult)result, startVec, endVec);
        }
    }

    protected double getFluidDrag() {
        FluidState fluidState = this.m_9236_().m_6425_(this.m_20183_());
        Fluid fluid = fluidState.m_76152_();
        int density = fluid.getFluidType().getDensity();
        if (density <= 0) {
            return 1.0;
        }
        return 1.0 / (1.0 + (double)density / 1000.0);
    }

    @Nullable
    private List<EntityResult> getHitEntityResult(Vec3 startVec, Vec3 endVec) {
        List<EntityResult> hitEntities = null;
        if (this.pierceCount == 0) {
            EntityResult entityResult = this.findEntityOnPath(this.shooter, startVec, endVec);
            if (entityResult != null) {
                hitEntities = Collections.singletonList(entityResult);
            }
        } else {
            hitEntities = this.findEntitiesOnPath(startVec, endVec);
        }
        return hitEntities;
    }

    protected Predicate<BlockState> getBlockFilter() {
        return value -> false;
    }

    protected void onProjectileTick() {
    }

    protected void onExpired() {
        if (ExplosionUtils.isExplosive(this.projectile.getExplosion())) {
            ExplosionUtils.createExplosion(this, this.projectile.getExplosion(), this.m_20182_());
        }
    }

    protected boolean removeOnHit(HitTarget hitTarget) {
        return hitTarget != HitTarget.FLUID;
    }

    @Nullable
    protected EntityResult findEntityOnPath(LivingEntity shooter, Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> PROJECTILE_TARGETS.test((Entity)entity) && shooter != null && shooter.m_20202_() != entity);
        double closestDistance = Double.MAX_VALUE;
        for (Entity target : entities) {
            Vec3 hitPos;
            double distanceToHit;
            EntityResult result;
            if (target.equals((Object)this.shooter) || (result = this.getHitResult(target, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = target;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    protected void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60819_().m_76178_()) {
                this.onHitFluid(blockHitResult, state);
            } else {
                this.onHitBlock(blockHitResult, state);
            }
        } else if (result instanceof ExtendedEntityRayTraceResult) {
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            this.onHitEntity(entityHitResult);
        }
    }

    protected void onHitEntity(ExtendedEntityRayTraceResult entityHitResult) {
        Player player;
        Entity entity = entityHitResult.m_82443_();
        Vec3 hitVec = entityHitResult.m_82450_();
        if (entity.m_19879_() == this.shooter.m_19879_()) {
            return;
        }
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof Player && entity.m_20367_((Entity)(player = (Player)livingEntity))) {
            return;
        }
        this.burnEntity(entity);
        this.damageEntity(entity, entityHitResult);
        PacketHandler.getPlayChannel().sendToTrackingEntity(() -> entity, new S2CMessageBlood(hitVec));
        this.onContact(hitVec);
        this.handlePierce(HitTarget.ENTITY);
        entity.f_19802_ = 0;
    }

    protected void onHitBlock(BlockHitResult blockHitResult, BlockState state) {
        BlockPos blockPos = blockHitResult.m_82425_();
        Block block = state.m_60734_();
        Vec3 hitVec = blockHitResult.m_82450_();
        this.sendHitBlockMessage(blockHitResult, hitVec);
        this.handleBlockBreaking(blockPos, state);
        this.onContact(hitVec);
        this.checkDamageable(state, blockPos);
        this.checkTargetBlock(blockHitResult, state);
        this.checkBellBlock(blockHitResult, block, blockPos);
        if (blockPos.equals((Object)this.hitBlockpos) && !state.m_247087_()) {
            this.handlePierce(HitTarget.BLOCK);
            this.playHitSound();
        }
        this.hitBlockpos = blockPos;
    }

    protected void playHitSound() {
        ResourceLocation hitSound = this.projectile.getHitSound();
        if (hitSound != null) {
            SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(hitSound);
            this.m_5496_(sound, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        }
    }

    protected void onHitFluid(BlockHitResult hitResult, BlockState state) {
        Vec3 pos = hitResult.m_82450_();
        FluidState fluidState = state.m_60819_();
        boolean isLava = fluidState.m_205070_(FluidTags.f_13132_);
        if (!this.f_19798_) {
            this.f_19798_ = true;
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)this.m_9236_(), (Vec3)pos, (double)32.0), new S2CMessageProjectileHitFluid(pos, this.m_20205_(), (float)this.m_20184_().m_82553_(), isLava, this.m_19879_()));
            this.m_146850_(GameEvent.f_157784_);
        }
        if (this.removeOnHit(HitTarget.FLUID)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void handlePierce(HitTarget hitTarget) {
        if (this.pierceCount == 0 && this.removeOnHit(hitTarget)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.pierceCount = Math.max(0, this.pierceCount - 1);
    }

    protected void burnEntity(Entity entity) {
        int burnTime = this.projectile.getBurnSeconds();
        if (burnTime > 0) {
            entity.m_20254_(burnTime);
        }
    }

    private void damageEntity(Entity entity, ExtendedEntityRayTraceResult hitResult) {
        float criticalDamage;
        boolean isCritical;
        float damage = this.getDamage();
        boolean bl = isCritical = damage != (criticalDamage = this.getCriticalDamage(this.weapon, this.f_19796_, damage));
        if (hitResult.isHeadshot()) {
            criticalDamage = (float)((double)criticalDamage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        entity.m_6469_(this.getDamageSource(), criticalDamage);
        this.sendEntityHitMessage(entity, hitResult.m_82450_(), hitResult.isHeadshot(), isCritical);
    }

    protected void onContact(Vec3 hitVec) {
        if (this.projectile.getExplosion().isExplodeOnContact() && ExplosionUtils.isExplosive(this.projectile.getExplosion())) {
            ExplosionUtils.createExplosion(this, this.projectile.getExplosion(), hitVec);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void handleBlockBreaking(BlockPos pos, BlockState state) {
        float destroySpeed;
        if (ModTags.isFragile(state) && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
            float chance = ((Double)Config.COMMON.gameplay.griefing.fragileBaseBreakChance.get()).floatValue() / (destroySpeed + 1.0f);
            if (this.f_19796_.m_188501_() < chance) {
                this.m_9236_().m_46961_(pos, ((Boolean)Config.COMMON.gameplay.griefing.fragileBlockDrops.get()).booleanValue());
            }
        }
    }

    protected void updateHeading() {
        double horizontalDistance = this.m_20184_().m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected static BlockHitResult rayTraceBlocks(Level level, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return RayTraceHelper.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = level.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)level, blockPos);
            BlockHitResult blockResult = level.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)level, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d.f_82479_, (double)Vector3d.f_82480_, (double)Vector3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private void setupStartPosition(LivingEntity shooter) {
        double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
        double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
        double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
    }

    private LevelLocation getDeathTargetPoint() {
        return LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)256.0);
    }

    private ItemStack setupAmmo(WeaponData data) {
        Item ammo;
        ItemStack weapon = data.weapon;
        AmmoHolder ammoHolder = WeaponStateHelper.getCurrentAmmo(data);
        if (ammoHolder.canReturnAmmo() && (ammo = (Item)ForgeRegistries.ITEMS.getValue(ammoHolder.getId())) != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128425_("Model", 10) && (model = ItemStack.m_41712_((CompoundTag)weapon.m_41783_().m_128469_("Model"))).m_41783_() != null && model.m_41783_().m_128441_("CustomModelData")) {
                customModelData = model.m_41783_().m_128451_("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((ItemLike)ammo);
            if (customModelData != -1) {
                ammoStack.m_41784_().m_128405_("CustomModelData", customModelData);
            }
            return ammoStack;
        }
        return ItemStack.f_41583_;
    }

    protected void setupDirection(LivingEntity shooter, ItemStack weapon, IWeapon item) {
        Vec3 dir = this.getDirection(shooter, weapon, item);
        float speed = this.projectile.getSpeed();
        this.m_20334_(dir.f_82479_ * (double)speed, dir.f_82480_ * (double)speed, dir.f_82481_ * (double)speed);
        this.updateHeading();
    }

    protected float getCriticalDamage(ItemStack weapon, RandomSource rand, float damage) {
        WeaponData data = new WeaponData(weapon, this.shooter);
        float chance = WeaponModifierHelper.getCriticalChance(data);
        if (rand.m_188501_() < chance) {
            return (float)((double)damage * (Double)Config.COMMON.gameplay.criticalDamageMultiplier.get());
        }
        return damage;
    }

    protected Vec3 getDirection(LivingEntity shooter, ItemStack weapon, IWeapon item) {
        WeaponData data = new WeaponData(weapon, shooter);
        float gunSpread = WeaponModifierHelper.getSpread(data);
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (!WeaponModifierHelper.isAlwaysSpread(data)) {
            gunSpread *= SpreadTracker.get(shooter).getSpread(item);
        }
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)shooter)).booleanValue()) {
            gunSpread *= 0.5f;
        }
        return this.getVectorFromRotation(shooter.m_146909_() - gunSpread / 2.0f + this.f_19796_.m_188501_() * gunSpread, shooter.m_6080_() - gunSpread / 2.0f + this.f_19796_.m_188501_() * gunSpread);
    }

    @NotNull
    private DamageSource getDamageSource() {
        return new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(this.projectile.getDamageType()));
    }

    private void sendEntityHitMessage(Entity entity, Vec3 hitVec, boolean headshot, boolean isCritical) {
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer playerShooter = (ServerPlayer)livingEntity;
            int bodyHitType = headshot ? 1 : 0;
            int hitType = isCritical ? 2 : bodyHitType;
            PacketHandler.getPlayChannel().sendToPlayer(() -> playerShooter, new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
    }

    private void sendHitBlockMessage(BlockHitResult hitResult, Vec3 hitVec) {
        BlockPos blockPos = hitResult.m_82425_();
        S2CMessageProjectileHitBlock message = new S2CMessageProjectileHitBlock(hitVec, blockPos, hitResult.m_82434_());
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(blockPos), message);
    }

    @Nullable
    private EntityResult getHitResult(Entity target, Vec3 startVec, Vec3 endVec) {
        double expandHeight = target instanceof Player && !target.m_6047_() ? 0.0625 : 0.0;
        AABB boundingBox = target.m_20191_();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue() && target instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)target;
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer shooterPlayer = (ServerPlayer)livingEntity;
                int ping = (int)Math.floor((double)shooterPlayer.f_8943_ / 1000.0 * 20.0 + 0.5);
                boundingBox = BoundingBoxManager.getBoundingBox((Player)targetPlayer, ping);
            }
        }
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        Vec3 grownHitPos = boundingBox.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue()).m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            ClipContext clipContext = new ClipContext(startVec, grownHitPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this);
            BlockHitResult rayTraceResult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), clipContext, this.getBlockFilter());
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.COMMON.gameplay.enableHeadShots.get()).booleanValue() && target instanceof LivingEntity) {
            AABB box;
            LivingEntity livingEntity = (LivingEntity)target;
            IHeadshotBox<LivingEntity> headshotBox = BoundingBoxManager.getHeadshotBoxes(target.m_6095_());
            if (headshotBox != null && (box = headshotBox.getHeadshotBox(livingEntity)) != null) {
                Optional headshotHitPos = (box = box.m_82386_(boundingBox.m_82399_().f_82479_, boundingBox.f_82289_, boundingBox.m_82399_().f_82481_)).m_82371_(startVec, endVec);
                if (!headshotHitPos.isPresent()) {
                    box = box.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue());
                    headshotHitPos = box.m_82371_(startVec, endVec);
                }
                if (headshotHitPos.isPresent() && (hitPos == null || ((Vec3)headshotHitPos.get()).m_82554_(hitPos) < 0.5)) {
                    hitPos = (Vec3)headshotHitPos.get();
                    headshot = true;
                }
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(target, hitPos, headshot);
    }

    private Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    private void checkDamageable(BlockState state, BlockPos blockPos) {
        Block block = state.m_60734_();
        if (block instanceof IDamageable) {
            IDamageable damageable = (IDamageable)block;
            damageable.onBlockDamaged(this, state, blockPos, this.getDamage());
        }
    }

    private void checkBellBlock(BlockHitResult blockHitResult, Block block, BlockPos blockPos) {
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), blockPos, blockHitResult.m_82434_());
        }
    }

    private void checkTargetBlock(BlockHitResult blockHitResult, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof TargetBlock) {
            TargetBlock targetBlock = (TargetBlock)block;
            int power = ReflectionUtil.updateTargetBlock(targetBlock, (LevelAccessor)this.m_9236_(), state, blockHitResult, this);
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.m_36220_(Stats.f_12953_);
                CriteriaTriggers.f_10561_.m_70211_(serverPlayer, (Entity)this, blockHitResult.m_82450_(), power);
            }
        }
    }
}

