/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.util.SetUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponStateHelper {
    public static final String AMMO_TAG = "Ammo";
    public static final String FIRE_MODE = "FireMode";
    public static final String ATTACHMENTS = "Attachments";

    public static void switchAmmo(WeaponData data) {
        Set<AmmoHolder> ammoItems = WeaponModifierHelper.getAmmoItems(data);
        AmmoHolder current = WeaponStateHelper.getCurrentAmmo(data);
        AmmoHolder newAmmo = SetUtils.cycleSet(ammoItems, current);
        WeaponStateHelper.setCurrentAmmo(data, newAmmo.getId());
    }

    public static ResourceKey<DamageType> getDamageType(WeaponData data) {
        ProjectileConfig ammo = WeaponStateHelper.getProjectileConfig(data);
        return ammo.getDamageType();
    }

    public static float getProjectileDamage(WeaponData data) {
        ResourceLocation ammo = WeaponStateHelper.getCurrentAmmo(data).getId();
        return WeaponModifierHelper.getProjectileDamage(ammo, data);
    }

    public static int getAmmoCount(WeaponData data) {
        CompoundTag tag = data.weapon.m_41784_();
        return tag.m_128451_("AmmoCount");
    }

    public static void addAmmo(WeaponData data, int amount) {
        CompoundTag tag = data.weapon.m_41784_();
        int maxAmmo = WeaponModifierHelper.getMaxAmmo(data);
        int result = Math.min(tag.m_128451_("AmmoCount") + amount, maxAmmo);
        tag.m_128405_("AmmoCount", result);
        data.weapon.m_41751_(tag);
    }

    public static void setCurrentAmmo(WeaponData data, ResourceLocation ammo) {
        CompoundTag tag = data.weapon.m_41784_();
        tag.m_128359_(AMMO_TAG, ammo.toString());
        data.weapon.m_41751_(tag);
    }

    public static AmmoHolder getCurrentAmmo(WeaponData data) {
        CompoundTag tag = data.weapon.m_41784_();
        if (tag.m_128425_(AMMO_TAG, 8)) {
            String ammoId = tag.m_128461_(AMMO_TAG);
            return AmmoHolder.getType(ammoId);
        }
        Set<AmmoHolder> ammoItems = WeaponModifierHelper.getAmmoItems(data);
        return SetUtils.getFirst(ammoItems);
    }

    public static AmmoHolder getCurrentAmmoWithoutCheck(WeaponData data) {
        CompoundTag tag = data.weapon.m_41784_();
        Set<AmmoHolder> ammoItems = WeaponModifierHelper.getAmmoItems(data);
        if (tag.m_128425_(AMMO_TAG, 8)) {
            return AmmoHolder.getType(tag.m_128461_(AMMO_TAG));
        }
        AmmoHolder firstAmmo = SetUtils.getFirst(ammoItems);
        WeaponStateHelper.setCurrentAmmo(data, firstAmmo.getId());
        return firstAmmo;
    }

    public static boolean isAcceptable(WeaponData weaponData, ItemStack item) {
        return WeaponStateHelper.getCurrentAmmo(weaponData).isAcceptable(item);
    }

    public static AmmoConfig getAmmoConfig(WeaponData data) {
        ResourceLocation ammoId = WeaponStateHelper.getCurrentAmmo(data).getId();
        return WeaponModifierHelper.getAmmoConfig(ammoId, data);
    }

    @NotNull
    public static ProjectileConfig getProjectileConfig(WeaponData data) {
        ResourceLocation ammoId = WeaponStateHelper.getCurrentAmmoWithoutCheck(data).getId();
        return WeaponModifierHelper.getProjectileConfig(ammoId, data);
    }

    public static void switchFireMode(WeaponData data) {
        Set<FireMode> fireModes = WeaponModifierHelper.getFireModes(data);
        FireMode current = WeaponStateHelper.getFireMode(data);
        FireMode newFireMode = SetUtils.cycleSet(fireModes, current);
        WeaponStateHelper.setFireMode(data, newFireMode);
    }

    public static void setFireMode(WeaponData data, FireMode fireMode) {
        CompoundTag tag = data.weapon.m_41784_();
        tag.m_128359_(FIRE_MODE, fireMode.toString());
        data.weapon.m_41751_(tag);
    }

    public static FireMode getFireMode(WeaponData data) {
        Set<FireMode> fireModes = WeaponModifierHelper.getFireModes(data);
        FireMode currentFireMode = WeaponStateHelper.getFireMode(data.weapon);
        if (currentFireMode == null || !fireModes.contains(currentFireMode)) {
            WeaponStateHelper.setFireMode(data, SetUtils.getFirst(fireModes));
            return SetUtils.getFirst(fireModes);
        }
        return currentFireMode;
    }

    @Nullable
    private static FireMode getFireMode(ItemStack gun) {
        CompoundTag tag = gun.m_41784_();
        if (tag.m_128425_(FIRE_MODE, 8)) {
            return FireMode.getType(tag.m_128461_(FIRE_MODE));
        }
        return null;
    }

    public static boolean isMaxAmmo(WeaponData data) {
        int maxAmmo;
        int ammo = WeaponStateHelper.getAmmoCount(data);
        return ammo == (maxAmmo = WeaponModifierHelper.getMaxAmmo(data));
    }

    public static void setAmmo(ItemStack gunStack, int amount) {
        CompoundTag tag = gunStack.m_41784_();
        tag.m_128405_("AmmoCount", amount);
    }

    public static void setMaxAmmo(WeaponData data) {
        WeaponStateHelper.setAmmo(data.weapon, WeaponModifierHelper.getMaxAmmo(data));
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static boolean hasEnoughAmmo(WeaponData data) {
        CompoundTag tag = data.weapon.m_41784_();
        int ammoPerShot = WeaponModifierHelper.getAmmoPerShot(data);
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") >= ammoPerShot;
    }

    public static void fillAmmo(WeaponData data) {
        if (data.weapon.m_41720_() instanceof IWeapon) {
            CompoundTag tag = data.weapon.m_41784_();
            int maxAmmo = WeaponModifierHelper.getMaxAmmo(data);
            tag.m_128405_("AmmoCount", maxAmmo);
        }
    }

    public static ArrayList<ItemStack> getAttachmentItems(ItemStack gun) {
        CompoundTag compound = gun.m_41783_();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            for (String slot : attachment.m_128431_()) {
                if (!attachment.m_128425_(slot, 10)) continue;
                result.add(ItemStack.m_41712_((CompoundTag)attachment.m_128469_(slot)));
            }
        }
        return result;
    }

    public static ItemStack getAttachmentItem(AttachmentType type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10) && (attachment = compound.m_128469_(ATTACHMENTS)).m_128425_(type.toString(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.toString()));
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasScopeOverlay(ItemStack gun) {
        ScopeItem scope = WeaponStateHelper.getScopeItem(gun);
        return scope != null && ((Scope)scope.getProperties()).hasOverlay();
    }

    @Nullable
    public static ScopeItem getScopeItem(ItemStack gun) {
        ItemStack attachment = WeaponStateHelper.getAttachmentItem(AttachmentType.SCOPE, gun);
        if (!attachment.m_41619_()) {
            return (ScopeItem)attachment.m_41720_();
        }
        return null;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, AttachmentType type) {
        WeaponConfig gun = WeaponModifierHelper.getConfig(new WeaponData(stack, null));
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            return attachment.m_128425_(type.toString(), 10);
        }
        return false;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        return WeaponStateHelper.getAttachmentItem(AttachmentType.SCOPE, gun);
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        ItemStack scopeStack = WeaponStateHelper.getScopeStack(gun);
        Item item = scopeStack.m_41720_();
        if (item instanceof ScopeItem) {
            ScopeItem scopeItem = (ScopeItem)item;
            if (Ntgl.isDebugging()) {
                return Debug.getScope(scopeItem);
            }
            return (Scope)scopeItem.getProperties();
        }
        return null;
    }

    public static float getFovModifier(WeaponData data) {
        Scope scope;
        float modifier = 0.0f;
        ItemStack weapon = data.weapon;
        if (WeaponStateHelper.hasAttachmentEquipped(weapon, AttachmentType.SCOPE) && (scope = WeaponStateHelper.getScope(weapon)) != null) {
            if (scope.getFovModifier() < 1.0f) {
                return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
            }
            modifier -= scope.getFovModifier();
        }
        float fovMod = WeaponModifierHelper.getFovModifier(data);
        return modifier + fovMod;
    }

    public static boolean isAmmoIgnored(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_("IgnoreAmmo", 1);
    }

    public static void saveAttachments(WeaponData data, Collection<ItemStack> attachments) {
        ItemStack weapon = data.weapon;
        CompoundTag attachmentsTag = new CompoundTag();
        for (ItemStack itemStack : attachments) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof IAttachment)) continue;
            IAttachment attachment = (IAttachment)item;
            AttachmentType tagKey = attachment.getType();
            attachmentsTag.m_128365_(tagKey.toString(), (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        CompoundTag tag = weapon.m_41784_();
        tag.m_128365_(ATTACHMENTS, (Tag)attachmentsTag);
    }

    private static boolean containsItem(Collection<ItemStack> whereFind, Collection<ItemStack> whatFind) {
        for (ItemStack att : whatFind) {
            if (WeaponStateHelper.contains(whereFind, att)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<ItemStack> list, ItemStack toFind) {
        for (ItemStack stack : list) {
            if (stack.m_41720_() != toFind.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public static void saveAttachment(ItemStack weapon, ItemStack attachmentStack) {
        Item item;
        CompoundTag tag = weapon.m_41784_();
        CompoundTag attachmentsTag = new CompoundTag();
        if (tag.m_128425_(ATTACHMENTS, 10)) {
            attachmentsTag = tag.m_128469_(ATTACHMENTS);
        }
        if ((item = attachmentStack.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            String tagKey = attachment.getType().toString();
            attachmentsTag.m_128365_(tagKey, (Tag)attachmentStack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(ATTACHMENTS, (Tag)attachmentsTag);
    }

    public static void consumeAmmo(WeaponData data) {
        LivingEntity shooter = data.wielder;
        ItemStack heldItem = data.weapon;
        if (shooter != null && heldItem != null) {
            int ammoPerShot = WeaponModifierHelper.getAmmoPerShot(data);
            FireMode fireMode = WeaponStateHelper.getFireMode(data);
            int multishotAmount = WeaponModifierHelper.getMultishotAmount(data);
            int ammoCount = WeaponStateHelper.getAmmoCount(data);
            if (fireMode == FireMode.MULTI && multishotAmount > 1) {
                multishotAmount = Math.min(ammoCount, multishotAmount);
                ammoPerShot *= multishotAmount;
            }
            int remainingAmmo = Math.max(0, ammoCount - ammoPerShot);
            WeaponStateHelper.setAmmo(heldItem, remainingAmmo);
        }
    }

    public static int getEquipTime(ItemStack slot, LivingEntity shooter) {
        int equipTime = 0;
        if (slot.m_41720_() instanceof IWeapon) {
            WeaponData data = new WeaponData(slot, shooter);
            equipTime = WeaponModifierHelper.getEquipTime(data);
        }
        return equipTime;
    }
}

