/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.chassis_core.client.animators.HandAnimator;
import com.nukateam.chassis_core.client.model.LeftHandModel;
import com.nukateam.chassis_core.client.model.RightHandModel;
import com.nukateam.chassis_core.client.render.utils.GeoUtils;
import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.foundation.item.ChassisEquipment;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoObjectRenderer;

public class CustomHandRenderer
extends GeoObjectRenderer<HandAnimator> {
    public static final String RIGHT_HAND_BONE = "right_arm_pov";
    public static final String LEFT_HAND_BONE = "left_arm_pov";
    public static final Lazy<RightHandModel> RIGHT_HAND_MODEL = Lazy.of(RightHandModel::new);
    public static final Lazy<LeftHandModel> LEFT_HAND_MODEL = Lazy.of(LeftHandModel::new);
    public static final String RIGHT_FOREARM_ARMOR = "right_forearm_armor";
    public static final String LEFT_FOREARM_ARMOR = "left_forearm_armor";
    protected HumanoidArm arm;

    public CustomHandRenderer() {
        super((GeoModel)new RightHandModel());
    }

    public GeoModel<HandAnimator> getGeoModel() {
        return this.arm == HumanoidArm.RIGHT ? (GeoModel)RIGHT_HAND_MODEL.get() : (GeoModel)LEFT_HAND_MODEL.get();
    }

    public void render(HumanoidArm arm, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, int packedLight) {
        this.arm = arm;
        super.render(poseStack, (GeoAnimatable)PlayerUtils.getLocalPlayerChassis().getHandEntity(), bufferSource, null, null, packedLight);
    }

    public void renderRecursively(PoseStack poseStack, HandAnimator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        WearableChassis chassis;
        if (PlayerUtils.isLocalWearingChassis() && (Objects.equals(bone.getName(), RIGHT_HAND_BONE) || Objects.equals(bone.getName(), LEFT_HAND_BONE)) && (chassis = PlayerUtils.getLocalPlayerChassis()).isEquipmentVisible(this.getArmorSlot())) {
            this.renderArmor(poseStack, animatable, chassis, buffer, bufferSource, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        super.renderRecursively(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void renderArmor(PoseStack poseStack, HandAnimator animatable, WearableChassis chassis, VertexConsumer buffer, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.isArmorVisible(chassis)) {
            GeoBone[] armorBones = this.gerArmor(chassis);
            poseStack.m_85836_();
            this.translateArmor(poseStack);
            for (GeoBone bone : armorBones) {
                this.renderBone(bone, poseStack, buffer, bufferSource, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }

    protected ChassisPart getArmorSlot() {
        return this.arm == HumanoidArm.RIGHT ? ChassisPart.RIGHT_ARM_ARMOR : ChassisPart.LEFT_ARM_ARMOR;
    }

    protected GeoBone[] gerArmor(WearableChassis chassis) {
        ChassisEquipment armor = Chassis.getAsChassisEquipment(chassis.getEquipment(this.getArmorSlot()));
        EquipmentConfig config = armor.getConfig();
        if (config != null) {
            ResourceLocation armorModel = armor.getConfig().getModel();
            if (this.arm == HumanoidArm.RIGHT) {
                return new GeoBone[]{GeoUtils.getBone(armorModel, RIGHT_FOREARM_ARMOR)};
            }
            return new GeoBone[]{GeoUtils.getBone(armorModel, LEFT_FOREARM_ARMOR)};
        }
        return new GeoBone[0];
    }

    protected boolean isArmorVisible(WearableChassis chassis) {
        return chassis.isEquipmentVisible(this.getArmorSlot());
    }

    protected void translateArmor(PoseStack poseStack) {
        if (this.arm == HumanoidArm.RIGHT) {
            poseStack.m_85837_(-0.5125, -1.375, 0.1875);
        } else {
            poseStack.m_85837_(0.4875, -1.34375, 0.19375);
        }
    }

    private void renderBone(GeoBone armorBone, PoseStack poseStack, VertexConsumer buffer, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ResourceLocation texture;
        WearableChassis chassis = PlayerUtils.getLocalPlayerChassis();
        ResourceLocation textureOverride = GeoUtils.getTextureForBone(armorBone, chassis);
        ResourceLocation resourceLocation = texture = textureOverride == null ? this.getTextureLocation((GeoAnimatable)((HandAnimator)this.animatable)) : textureOverride;
        if (texture != null) {
            RenderType renderTypeOverride = this.getRenderType((GeoAnimatable)((HandAnimator)this.animatable), texture, bufferSource, partialTick);
            buffer = bufferSource.m_6299_(renderTypeOverride);
            for (GeoCube cube : armorBone.getCubes()) {
                poseStack.m_85836_();
                GeoCube newCube = new GeoCube(cube.quads(), new Vec3(0.0, 0.0, 0.0), cube.rotation(), cube.size(), cube.inflate(), cube.mirror());
                this.renderCube(poseStack, newCube, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                poseStack.m_85849_();
            }
            buffer = bufferSource.m_6299_(this.getRenderType((GeoAnimatable)((HandAnimator)this.animatable), this.getTextureLocation((GeoAnimatable)((HandAnimator)this.animatable)), bufferSource, partialTick));
        }
    }
}

