/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.item;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StackUtils {
    public static final String DEFAULT = "default";
    public static final String VARIANT = "variant";
    public static final String ATTACHMENTS = "mods";

    public static String getVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(VARIANT) ? tag.m_128461_(VARIANT) : DEFAULT;
    }

    public static void setVariant(ItemStack stack, String variant) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(VARIANT, variant);
        stack.m_41751_(tag);
    }

    public static boolean hasAttachment(ItemStack stack, String mod) {
        ArrayList<String> mods = StackUtils.getAttachments(stack);
        return mods.contains(mod);
    }

    public static ArrayList<String> getAttachments(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ATTACHMENTS)) {
            return new ArrayList<String>();
        }
        CompoundTag attachments = tag.m_128469_(ATTACHMENTS);
        ArrayList<String> values = new ArrayList<String>();
        for (String key : attachments.m_128431_()) {
            values.add(attachments.m_128461_(key));
        }
        return values;
    }

    public static String getAttachment(ItemStack stack, String slot) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ATTACHMENTS) || !tag.m_128469_(ATTACHMENTS).m_128441_(slot)) {
            return null;
        }
        return tag.m_128469_(ATTACHMENTS).m_128461_(slot);
    }

    public static void setAttachment(ItemStack stack, String slot, String attachment) {
        CompoundTag stackTag = stack.m_41784_();
        CompoundTag listTag = new CompoundTag();
        listTag.m_128359_(slot, attachment);
        stackTag.m_128365_(ATTACHMENTS, (Tag)listTag);
        stack.m_41751_(stackTag);
    }
}

