/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.modules.example.common.entities;

import com.nukateam.chassis_core.client.animators.HandAnimator;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.modules.example.common.container.ExampleChassisStationMenu;
import com.nukateam.chassis_core.modules.example.common.entities.ExampleChassisHand;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ExampleChassis
extends WearableChassis {
    public static final ResourceLocation ICON = new ResourceLocation("ntgl", "textures/items/power_armor_frame.png");
    public static final ExampleChassisHand HAND = new ExampleChassisHand();
    public RawAnimation currentAnimation = null;

    public ExampleChassis(EntityType<? extends WearableChassis> type, Level worldIn) {
        super((EntityType<? extends Chassis>)type, worldIn);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            this.damageArmor(damageSource, damage);
            return false;
        }
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_142535_(float height, float pMultiplier, DamageSource damageSource) {
        int damage = this.m_5639_(height, pMultiplier);
        if (damage >= 0) {
            this.m_6469_(damageSource, damage);
        }
        return false;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public HandAnimator getHandEntity() {
        return HAND;
    }

    @Override
    protected MenuProvider getStantionMenuProvider() {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int id, Inventory menu, Player player) {
                return new ExampleChassisStationMenu(id, (Container)ExampleChassis.this.inventory, menu, ExampleChassis.this);
            }

            public Component m_5446_() {
                return ExampleChassis.this.m_5446_();
            }
        };
    }

    @Override
    public Boolean isWalking() {
        return this.speedometer.getSpeed() > 0.0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "arm_controller", 0, this.animateArms())});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "leg_controller", 0, this.animateLegs())});
    }

    private AnimationController.AnimationStateHandler<ExampleChassis> animateArms() {
        return event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation animation = null;
            LivingEntity passenger = this.m_6688_();
            if (passenger != null) {
                if (passenger.f_20921_ > 0.0f) {
                    controller.setAnimationSpeed(2.0);
                    animation = RawAnimation.begin().then("hit", Animation.LoopType.PLAY_ONCE);
                } else if (this.f_20916_ > 0) {
                    animation = RawAnimation.begin().then("hurt", Animation.LoopType.PLAY_ONCE);
                } else if (this.isWalking().booleanValue()) {
                    controller.setAnimationSpeed(this.speedometer.getSpeed() * 4.0);
                    animation = RawAnimation.begin().then("walk_arms", Animation.LoopType.LOOP);
                } else {
                    animation = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
                }
            }
            this.currentAnimation = animation;
            return animation != null ? event.setAndContinue(animation) : PlayState.STOP;
        };
    }

    private AnimationController.AnimationStateHandler<ExampleChassis> animateLegs() {
        return event -> {
            RawAnimation animation;
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            LivingEntity passenger = this.m_6688_();
            if (passenger == null) {
                return PlayState.STOP;
            }
            if (this.isWalking().booleanValue()) {
                if (passenger.m_6144_()) {
                    animation = RawAnimation.begin().then("sneak_walk", Animation.LoopType.LOOP);
                } else {
                    animation = RawAnimation.begin().then("walk_legs", Animation.LoopType.LOOP);
                    controller.setAnimationSpeed(this.speedometer.getSpeed() * 4.0);
                }
            } else if (passenger.m_6144_()) {
                animation = RawAnimation.begin().then("sneak_end", Animation.LoopType.LOOP);
            } else {
                return PlayState.STOP;
            }
            return event.setAndContinue(animation);
        };
    }
}

